/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;

public class RegexReplaceExtractor
extends Extractor {
    private static final String CONFIG_REGEX = "regex";
    private static final String CONFIG_REPLACEMENT = "replacement";
    private static final String CONFIG_REPLACE_ALL = "replace_all";
    private static final String DEFAULT_REPLACE_VALUE = "$1";
    private final Pattern pattern;
    private final String replacement;
    private final boolean replaceAll;

    public RegexReplaceExtractor(MetricRegistry metricRegistry, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.REGEX_REPLACE, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null || extractorConfig.isEmpty()) {
            throw new ConfigurationException("Missing configuration");
        }
        Object configRegexValue = extractorConfig.get(CONFIG_REGEX);
        if (!(configRegexValue instanceof String) || ((String)configRegexValue).isEmpty()) {
            throw new ConfigurationException("Missing configuration field: regex");
        }
        Object configReplaceValue = extractorConfig.get(CONFIG_REPLACEMENT);
        if (configReplaceValue != null && !(configReplaceValue instanceof String)) {
            throw new ConfigurationException("Missing configuration field: replacement");
        }
        Object configReplaceAll = extractorConfig.get(CONFIG_REPLACE_ALL);
        if (configReplaceAll != null && !(configReplaceAll instanceof Boolean)) {
            throw new ConfigurationException("Missing configuration field: replace_all");
        }
        this.pattern = Pattern.compile((String)configRegexValue, 32);
        this.replacement = Strings.isNullOrEmpty((String)((String)configReplaceValue)) ? DEFAULT_REPLACE_VALUE : (String)configReplaceValue;
        this.replaceAll = configReplaceAll != null && (Boolean)configReplaceAll != false;
    }

    @Override
    protected Extractor.Result[] run(String value) {
        Extractor.Result[] resultArray;
        Extractor.Result result = this.runExtractor(value);
        if (result == null) {
            resultArray = null;
        } else {
            Extractor.Result[] resultArray2 = new Extractor.Result[1];
            resultArray = resultArray2;
            resultArray2[0] = result;
        }
        return resultArray;
    }

    public Extractor.Result runExtractor(String value) {
        String s;
        Matcher matcher = this.pattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return null;
        }
        int start = matcher.groupCount() > 0 ? matcher.start(1) : -1;
        int end = matcher.groupCount() > 0 ? matcher.end(1) : -1;
        try {
            s = this.replaceAll ? matcher.replaceAll(this.replacement) : matcher.replaceFirst(this.replacement);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to replace string", e);
        }
        return new Extractor.Result(s, start, end);
    }
}

