/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.indexer.indexset.DefaultIndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.migrations.AutoValue_V20161124104700_AddRetentionRotationAndDefaultFlagToIndexSetMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20161124104700_AddRetentionRotationAndDefaultFlagToIndexSetMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20161124104700_AddRetentionRotationAndDefaultFlagToIndexSetMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final IndexSetService indexSetService;

    @Inject
    public V20161124104700_AddRetentionRotationAndDefaultFlagToIndexSetMigration(IndexSetService indexSetService, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.indexSetService = indexSetService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2016-11-24T10:47:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        ImmutableSet.Builder updatedIds = ImmutableSet.builder();
        ImmutableSet.Builder skippedIds = ImmutableSet.builder();
        IndexManagementConfig indexManagementConfig = this.clusterConfigService.get(IndexManagementConfig.class);
        Preconditions.checkState((indexManagementConfig != null ? 1 : 0) != 0, (Object)"Couldn't find index management configuration");
        for (IndexSetConfig indexSetConfig : this.indexSetService.findAll()) {
            IndexSetConfig.Builder updated = indexSetConfig.toBuilder();
            if (Strings.isNullOrEmpty((String)indexSetConfig.rotationStrategyClass())) {
                Preconditions.checkState((boolean)indexSetConfig.rotationStrategy().type().startsWith(indexManagementConfig.rotationStrategy()), (String)"rotation strategy config type <%s> does not match rotation strategy <%s>", (Object)indexSetConfig.rotationStrategy().type(), (Object)indexManagementConfig.rotationStrategy());
                LOG.info("Adding rotation_strategy_class <{}> to index set <{}>", (Object)indexManagementConfig.rotationStrategy(), (Object)indexSetConfig.id());
                updated.rotationStrategyClass(indexManagementConfig.rotationStrategy());
            }
            if (Strings.isNullOrEmpty((String)indexSetConfig.retentionStrategyClass())) {
                Preconditions.checkState((boolean)indexSetConfig.retentionStrategy().type().startsWith(indexManagementConfig.retentionStrategy()), (String)"retention strategy config type <%s> does not match retention strategy <%s>", (Object)indexSetConfig.retentionStrategy().type(), (Object)indexManagementConfig.retentionStrategy());
                LOG.info("Adding retention_strategy_class <{}> to index set <{}>", (Object)indexManagementConfig.retentionStrategy(), (Object)indexSetConfig.id());
                updated.retentionStrategyClass(indexManagementConfig.retentionStrategy());
            }
            if (!indexSetConfig.equals(updated.build())) {
                this.indexSetService.save(updated.build());
                updatedIds.add((Object)Optional.ofNullable(indexSetConfig.id()).orElseThrow(() -> new IllegalStateException("no id??")));
                continue;
            }
            skippedIds.add((Object)Optional.ofNullable(indexSetConfig.id()).orElseThrow(() -> new IllegalStateException("no id??")));
        }
        IndexSetConfig defaultIndexSetConfig = this.indexSetService.findAll().stream().sorted(Comparator.comparing(IndexSetConfig::creationDate)).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find any index set - this should not happen!"));
        LOG.info("Setting index set <{}> as default", (Object)defaultIndexSetConfig.id());
        this.clusterConfigService.write(DefaultIndexSetConfig.create(defaultIndexSetConfig.id()));
        this.clusterConfigService.write(MigrationCompleted.create((Set<String>)updatedIds.build(), (Set<String>)skippedIds.build(), defaultIndexSetConfig.id()));
    }

    @JsonAutoDetect
    public static abstract class MigrationCompleted {
        @JsonProperty(value="updated_index_set_ids")
        public abstract Set<String> updatedIndexSetIds();

        @JsonProperty(value="skipped_index_set_ids")
        public abstract Set<String> skippedIndexSetIds();

        @JsonProperty(value="default_index_set")
        public abstract String defaultIndexSet();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="updated_index_set_ids") Set<String> updatedIndexSetIds, @JsonProperty(value="skipped_index_set_ids") Set<String> skippedIndexSetIds, @JsonProperty(value="default_index_set") String defaultIndexSet) {
            return new AutoValue_V20161124104700_AddRetentionRotationAndDefaultFlagToIndexSetMigration_MigrationCompleted(updatedIndexSetIds, skippedIndexSetIds, defaultIndexSet);
        }
    }
}

