/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;

public class DiscardMessageOutput
implements MessageOutput {
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Journal journal;
    private final Meter messagesDiscarded;

    @AssistedInject
    public DiscardMessageOutput(Journal journal, MetricRegistry metricRegistry, @Assisted Stream stream, @Assisted Configuration configuration) {
        this(journal, metricRegistry);
    }

    @Inject
    public DiscardMessageOutput(Journal journal, MetricRegistry metricRegistry) {
        this.journal = journal;
        this.messagesDiscarded = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"messagesDiscarded"}));
        this.isRunning.set(true);
    }

    @Override
    public void stop() {
        this.isRunning.set(false);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Override
    public void write(Message message) throws Exception {
        this.journal.markJournalOffsetCommitted(message.getJournalOffset());
        this.messagesDiscarded.mark();
    }

    @Override
    public void write(List<Message> messages) throws Exception {
        long maxOffset = Long.MIN_VALUE;
        for (Message message : messages) {
            maxOffset = Math.max(message.getJournalOffset(), maxOffset);
        }
        this.journal.markJournalOffsetCommitted(maxOffset);
        this.messagesDiscarded.mark((long)messages.size());
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("Discard Message output", false, "", "Output that discards messages");
        }
    }

    public static class Config
    extends MessageOutput.Config {
    }

    public static interface Factory
    extends MessageOutput.Factory<DiscardMessageOutput> {
    }
}

