/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.util;

import org.graylog2.plugin.inputs.MessageInput;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketInformationDumper
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PacketInformationDumper.class);
    private final Logger sourceInputLog;
    private final String sourceInputName;
    private final String sourceInputId;

    public PacketInformationDumper(MessageInput sourceInput) {
        this.sourceInputName = sourceInput.getName();
        this.sourceInputId = sourceInput.getId();
        this.sourceInputLog = LoggerFactory.getLogger((String)(PacketInformationDumper.class.getCanonicalName() + "." + this.sourceInputId));
        LOG.debug("Set {} to TRACE for network packet metadata dumps of input {}", (Object)this.sourceInputLog.getName(), (Object)sourceInput.getUniqueReadableId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (this.sourceInputLog.isTraceEnabled()) {
                ChannelBuffer message = (ChannelBuffer)e.getMessage();
                this.sourceInputLog.trace("Recv network data: {} bytes via input '{}' <{}> from remote address {}", new Object[]{message.readableBytes(), this.sourceInputName, this.sourceInputId, e.getRemoteAddress()});
            }
        }
        finally {
            super.messageReceived(ctx, e);
        }
    }
}

