/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;

public class StreamMetrics {
    private final MetricRegistry metricRegistry;
    private final Map<String, Meter> streamIncomingMeters = Maps.newHashMap();
    private final Map<String, Timer> streamExecutionTimers = Maps.newHashMap();
    private final Map<String, Meter> streamExceptionMeters = Maps.newHashMap();
    private final Map<String, Meter> streamRuleTimeoutMeters = Maps.newHashMap();
    private final Map<String, Meter> streamFaultsExceededMeters = Maps.newHashMap();

    @Inject
    public StreamMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void markIncomingMeter(String streamId) {
        this.getIncomingMeter(streamId).mark();
    }

    public Timer getExecutionTimer(String streamRuleId) {
        Timer timer = this.streamExecutionTimers.get(streamRuleId);
        if (timer == null) {
            timer = this.metricRegistry.timer(MetricRegistry.name(StreamRule.class, (String[])new String[]{streamRuleId, "executionTime"}));
            this.streamExecutionTimers.put(streamRuleId, timer);
        }
        return timer;
    }

    public void markExceptionMeter(String streamId) {
        this.getExceptionMeter(streamId).mark();
    }

    public void markStreamRuleTimeout(String streamId) {
        this.getStreamRuleTimeoutMeter(streamId).mark();
    }

    public void markStreamFaultsExceeded(String streamId) {
        this.getStreamFaultsExceededMeter(streamId).mark();
    }

    private Meter getIncomingMeter(String streamId) {
        Meter meter = this.streamIncomingMeters.get(streamId);
        if (meter == null) {
            meter = this.metricRegistry.meter(MetricRegistry.name(Stream.class, (String[])new String[]{streamId, "incomingMessages"}));
            this.streamIncomingMeters.put(streamId, meter);
        }
        return meter;
    }

    private Meter getExceptionMeter(String streamId) {
        Meter meter = this.streamExceptionMeters.get(streamId);
        if (meter == null) {
            meter = this.metricRegistry.meter(MetricRegistry.name(Stream.class, (String[])new String[]{streamId, "matchingExceptions"}));
            this.streamExceptionMeters.put(streamId, meter);
        }
        return meter;
    }

    private Meter getStreamRuleTimeoutMeter(String streamId) {
        Meter meter = this.streamRuleTimeoutMeters.get(streamId);
        if (meter == null) {
            meter = this.metricRegistry.meter(MetricRegistry.name(Stream.class, (String[])new String[]{streamId, "ruleTimeouts"}));
            this.streamRuleTimeoutMeters.put(streamId, meter);
        }
        return meter;
    }

    private Meter getStreamFaultsExceededMeter(String streamId) {
        Meter meter = this.streamFaultsExceededMeters.get(streamId);
        if (meter == null) {
            meter = this.metricRegistry.meter(MetricRegistry.name(Stream.class, (String[])new String[]{streamId, "faultsExceeded"}));
            this.streamFaultsExceededMeters.put(streamId, meter);
        }
        return meter;
    }
}

