/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.mongo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.database.MongoConnection;
import org.graylog2.system.stats.mongo.BuildInfo;
import org.graylog2.system.stats.mongo.DatabaseStats;
import org.graylog2.system.stats.mongo.HostInfo;
import org.graylog2.system.stats.mongo.MongoStats;
import org.graylog2.system.stats.mongo.ServerStatus;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoProbe {
    private static final Logger LOG = LoggerFactory.getLogger(MongoProbe.class);
    private final Mongo mongoClient;
    private final DB db;
    private final DB adminDb;
    private final BuildInfo buildInfo;
    private final HostInfo hostInfo;

    @Inject
    public MongoProbe(MongoConnection mongoConnection) {
        this(mongoConnection.connect(), mongoConnection.getDatabase());
    }

    @VisibleForTesting
    MongoProbe(Mongo mongoClient, DB db) {
        this(mongoClient, db, mongoClient.getDB("admin"), MongoProbe.createBuildInfo(mongoClient.getDB("admin")), MongoProbe.createHostInfo(mongoClient.getDB("admin")));
    }

    @VisibleForTesting
    MongoProbe(Mongo mongoClient, DB db, DB adminDB, BuildInfo buildInfo, HostInfo hostInfo) {
        this.mongoClient = (Mongo)Preconditions.checkNotNull((Object)mongoClient);
        this.db = (DB)Preconditions.checkNotNull((Object)db);
        this.adminDb = (DB)Preconditions.checkNotNull((Object)adminDB);
        this.buildInfo = buildInfo;
        this.hostInfo = hostInfo;
    }

    private static HostInfo createHostInfo(DB adminDb) {
        HostInfo hostInfo;
        CommandResult hostInfoResult = adminDb.command("hostInfo");
        if (hostInfoResult.ok()) {
            BasicDBObject systemMap = (BasicDBObject)hostInfoResult.get("system");
            HostInfo.System system = HostInfo.System.create(new DateTime((Object)systemMap.getDate("currentTime")), systemMap.getString("hostname"), systemMap.getInt("cpuAddrSize"), systemMap.getLong("memSizeMB"), systemMap.getInt("numCores"), systemMap.getString("cpuArch"), systemMap.getBoolean("numaEnabled"));
            BasicDBObject osMap = (BasicDBObject)hostInfoResult.get("os");
            HostInfo.Os os = HostInfo.Os.create(osMap.getString("type"), osMap.getString("name"), osMap.getString("version"));
            BasicDBObject extraMap = (BasicDBObject)hostInfoResult.get("extra");
            HostInfo.Extra extra = HostInfo.Extra.create(extraMap.getString("versionString"), extraMap.getString("libcVersion"), extraMap.getString("kernelVersion"), extraMap.getString("cpuFrequencyMHz"), extraMap.getString("cpuFeatures"), extraMap.getString("scheduler"), extraMap.getLong("pageSize", -1L), extraMap.getLong("numPages", -1L), extraMap.getLong("maxOpenFiles", -1L));
            hostInfo = HostInfo.create(system, os, extra);
        } else {
            LOG.debug("Couldn't retrieve MongoDB hostInfo: {}", (Object)hostInfoResult.getErrorMessage());
            hostInfo = null;
        }
        return hostInfo;
    }

    private static BuildInfo createBuildInfo(DB adminDb) {
        BuildInfo buildInfo;
        CommandResult buildInfoResult = adminDb.command("buildInfo");
        if (buildInfoResult.ok()) {
            buildInfo = BuildInfo.create(buildInfoResult.getString("version"), buildInfoResult.getString("gitVersion"), buildInfoResult.getString("sysInfo"), buildInfoResult.getString("loaderFlags"), buildInfoResult.getString("compilerFlags"), buildInfoResult.getString("allocator"), (List)buildInfoResult.get("versionArray"), buildInfoResult.getString("javascriptEngine"), buildInfoResult.getInt("bits"), buildInfoResult.getBoolean("debug"), buildInfoResult.getLong("maxBsonObjectSize"));
        } else {
            LOG.debug("Couldn't retrieve MongoDB buildInfo: {}", (Object)buildInfoResult.getErrorMessage());
            buildInfo = null;
        }
        return buildInfo;
    }

    public MongoStats mongoStats() {
        ServerStatus serverStatus;
        DatabaseStats dbStats;
        List serverAddresses = this.mongoClient.getServerAddressList();
        ArrayList servers = Lists.newArrayListWithCapacity((int)serverAddresses.size());
        for (ServerAddress serverAddress : serverAddresses) {
            servers.add(HostAndPort.fromParts((String)serverAddress.getHost(), (int)serverAddress.getPort()));
        }
        CommandResult dbStatsResult = this.db.command("dbStats");
        if (dbStatsResult.ok()) {
            BasicDBObject extentFreeListMap = (BasicDBObject)dbStatsResult.get("extentFreeList");
            DatabaseStats.ExtentFreeList extentFreeList = extentFreeListMap == null ? null : DatabaseStats.ExtentFreeList.create(extentFreeListMap.getInt("num"), extentFreeListMap.getInt("totalSize"));
            BasicDBObject dataFileVersionMap = (BasicDBObject)dbStatsResult.get("dataFileVersion");
            DatabaseStats.DataFileVersion dataFileVersion = dataFileVersionMap == null ? null : DatabaseStats.DataFileVersion.create(dataFileVersionMap.getInt("major"), dataFileVersionMap.getInt("minor"));
            dbStats = DatabaseStats.create(dbStatsResult.getString("db"), dbStatsResult.getLong("collections"), dbStatsResult.getLong("objects"), dbStatsResult.getDouble("avgObjSize"), dbStatsResult.getLong("dataSize"), dbStatsResult.getLong("storageSize"), dbStatsResult.getLong("numExtents"), dbStatsResult.getLong("indexes"), dbStatsResult.getLong("indexSize"), dbStatsResult.containsField("fileSize") ? Long.valueOf(dbStatsResult.getLong("fileSize")) : null, dbStatsResult.containsField("nsSizeMB") ? Long.valueOf(dbStatsResult.getLong("nsSizeMB")) : null, extentFreeList, dataFileVersion);
        } else {
            LOG.debug("Couldn't retrieve MongoDB dbStats: {}", (Object)dbStatsResult.getErrorMessage());
            dbStats = null;
        }
        CommandResult serverStatusResult = this.adminDb.command("serverStatus");
        if (serverStatusResult.ok()) {
            BasicDBObject connectionsMap = (BasicDBObject)serverStatusResult.get("connections");
            ServerStatus.Connections connections = ServerStatus.Connections.create(connectionsMap.getInt("current"), connectionsMap.getInt("available"), connectionsMap.containsField("totalCreated") ? Long.valueOf(connectionsMap.getLong("totalCreated")) : null);
            BasicDBObject networkMap = (BasicDBObject)serverStatusResult.get("network");
            ServerStatus.Network network = ServerStatus.Network.create(networkMap.getInt("bytesIn"), networkMap.getInt("bytesOut"), networkMap.getInt("numRequests"));
            BasicDBObject memoryMap = (BasicDBObject)serverStatusResult.get("mem");
            ServerStatus.Memory memory = ServerStatus.Memory.create(memoryMap.getInt("bits"), memoryMap.getInt("resident"), memoryMap.getInt("virtual"), memoryMap.getBoolean("supported"), memoryMap.getInt("mapped"), memoryMap.getInt("mappedWithJournal", -1));
            BasicDBObject storageEngineMap = (BasicDBObject)serverStatusResult.get("storageEngine");
            ServerStatus.StorageEngine storageEngine = storageEngineMap == null ? ServerStatus.StorageEngine.DEFAULT : ServerStatus.StorageEngine.create(storageEngineMap.getString("name"));
            int uptime = serverStatusResult.getInt("uptime", 0);
            serverStatus = ServerStatus.create(serverStatusResult.getString("host"), serverStatusResult.getString("version"), serverStatusResult.getString("process"), serverStatusResult.getLong("pid", 0L), uptime, serverStatusResult.getLong("uptimeMillis", (long)uptime * 1000L), serverStatusResult.getInt("uptimeEstimate"), new DateTime((Object)serverStatusResult.getDate("localTime")), connections, network, memory, storageEngine);
        } else {
            LOG.debug("Couldn't retrieve MongoDB serverStatus: {}", (Object)serverStatusResult.getErrorMessage());
            serverStatus = null;
        }
        return MongoStats.create(servers, this.buildInfo, this.hostInfo, serverStatus, dbStats);
    }
}

