/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.application.platforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hesperides.core.domain.modules.entities.Module;
import org.hesperides.core.domain.modules.exceptions.ModuleNotFoundException;
import org.hesperides.core.domain.modules.queries.ModuleQueries;
import org.hesperides.core.domain.platforms.commands.PlatformCommands;
import org.hesperides.core.domain.platforms.entities.Platform;
import org.hesperides.core.domain.platforms.entities.properties.AbstractValuedProperty;
import org.hesperides.core.domain.platforms.entities.properties.ValuedProperty;
import org.hesperides.core.domain.platforms.exceptions.ApplicationNotFoundException;
import org.hesperides.core.domain.platforms.exceptions.DuplicatePlatformException;
import org.hesperides.core.domain.platforms.exceptions.PlatformNotFoundException;
import org.hesperides.core.domain.platforms.queries.PlatformQueries;
import org.hesperides.core.domain.platforms.queries.views.ApplicationView;
import org.hesperides.core.domain.platforms.queries.views.DeployedModuleView;
import org.hesperides.core.domain.platforms.queries.views.InstancePropertyView;
import org.hesperides.core.domain.platforms.queries.views.ModulePlatformView;
import org.hesperides.core.domain.platforms.queries.views.PlatformView;
import org.hesperides.core.domain.platforms.queries.views.SearchApplicationResultView;
import org.hesperides.core.domain.platforms.queries.views.SearchPlatformResultView;
import org.hesperides.core.domain.platforms.queries.views.properties.AbstractValuedPropertyView;
import org.hesperides.core.domain.platforms.queries.views.properties.GlobalPropertyUsageView;
import org.hesperides.core.domain.platforms.queries.views.properties.ValuedPropertyView;
import org.hesperides.core.domain.security.User;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlatformUseCases {
    public static final String ROOT_PATH = "#";
    private final PlatformCommands commands;
    private final PlatformQueries queries;
    private final ModuleQueries moduleQueries;

    @Autowired
    public PlatformUseCases(PlatformCommands commands, PlatformQueries queries, ModuleQueries moduleQueries) {
        this.commands = commands;
        this.queries = queries;
        this.moduleQueries = moduleQueries;
    }

    public String createPlatform(Platform platform, User user) {
        if (this.queries.platformExists(platform.getKey())) {
            throw new DuplicatePlatformException(platform.getKey());
        }
        return this.commands.createPlatform(platform, user);
    }

    public String copyPlatform(Platform newPlatform, Platform.Key existingPlatformKey, User user) {
        Optional existingPlatformId = this.queries.getOptionalPlatformId(existingPlatformKey);
        if (!existingPlatformId.isPresent()) {
            throw new PlatformNotFoundException(existingPlatformKey);
        }
        if (this.queries.platformExists(newPlatform.getKey())) {
            throw new DuplicatePlatformException(newPlatform.getKey());
        }
        return this.commands.copyPlatform((String)existingPlatformId.get(), newPlatform, user);
    }

    public PlatformView getPlatform(String platformId) {
        return (PlatformView)this.queries.getOptionalPlatform(platformId).orElseThrow(() -> new PlatformNotFoundException(platformId));
    }

    public PlatformView getPlatform(Platform.Key platformKey) {
        return (PlatformView)this.queries.getOptionalPlatform(platformKey).orElseThrow(() -> new PlatformNotFoundException(platformKey));
    }

    public void updatePlatform(Platform.Key platformKey, Platform platform, boolean copyProperties, User user) {
        Optional platformId = this.queries.getOptionalPlatformId(platformKey);
        if (!platformId.isPresent()) {
            throw new PlatformNotFoundException(platformKey);
        }
        this.commands.updatePlatform((String)platformId.get(), platform, copyProperties, user);
    }

    public void deletePlatform(Platform.Key platformKey, User user) {
        Optional platformId = this.queries.getOptionalPlatformId(platformKey);
        if (!platformId.isPresent()) {
            throw new PlatformNotFoundException(platformKey);
        }
        this.commands.deletePlatform((String)platformId.get(), user);
    }

    public ApplicationView getApplication(String applicationName) {
        return (ApplicationView)this.queries.getApplication(applicationName).orElseThrow(() -> new ApplicationNotFoundException(applicationName));
    }

    public List<ModulePlatformView> getPlatformUsingModule(Module.Key moduleKey) {
        return this.queries.getPlatformsUsingModule((TemplateContainer.Key)moduleKey);
    }

    public List<SearchPlatformResultView> searchPlatforms(String applicationName, String platformName) {
        return this.queries.searchPlatforms(applicationName, platformName);
    }

    public List<SearchApplicationResultView> searchApplications(String applicationName) {
        return this.queries.searchApplications(applicationName);
    }

    public List<AbstractValuedPropertyView> getProperties(Platform.Key platformKey, String path, User user) {
        ArrayList<AbstractValuedPropertyView> properties = new ArrayList<AbstractValuedPropertyView>();
        if (!this.queries.platformExists(platformKey)) {
            throw new PlatformNotFoundException(platformKey);
        }
        if (ROOT_PATH.equals(path)) {
            properties.addAll(this.queries.getGlobalProperties(platformKey, user));
        } else if (StringUtils.isNotEmpty((CharSequence)path)) {
            Module.Key moduleKey = Module.Key.fromPath((String)path);
            if (!this.moduleQueries.moduleExists((TemplateContainer.Key)moduleKey)) {
                throw new ModuleNotFoundException((TemplateContainer.Key)moduleKey);
            }
            properties.addAll(this.queries.getDeployedModuleProperties(platformKey, path, user));
            properties.addAll(this.getGlobalPropertiesUsedInModule(platformKey, moduleKey));
        }
        return properties;
    }

    private List<AbstractValuedPropertyView> getGlobalPropertiesUsedInModule(Platform.Key platformKey, Module.Key moduleKey) {
        ArrayList<AbstractValuedPropertyView> globalPropertiesUsedInModule = new ArrayList<AbstractValuedPropertyView>();
        PlatformView platform = (PlatformView)this.queries.getOptionalPlatform(platformKey).get();
        Optional deployedModule = platform.getDeployedModule(moduleKey);
        if (deployedModule.isPresent()) {
            List moduleProperties = this.moduleQueries.getProperties((TemplateContainer.Key)moduleKey);
            List flatModuleProperties = AbstractPropertyView.flattenProperties((List)moduleProperties);
            platform.getGlobalProperties().forEach(globalProperty -> {
                List moduleGlobalProperties = GlobalPropertyUsageView.getModuleGlobalProperties((List)flatModuleProperties, (String)globalProperty.getName(), (String)((DeployedModuleView)deployedModule.get()).getPropertiesPath());
                if (!CollectionUtils.isEmpty((Collection)moduleGlobalProperties)) {
                    globalPropertiesUsedInModule.add((AbstractValuedPropertyView)globalProperty);
                }
            });
        }
        return globalPropertiesUsedInModule;
    }

    public List<InstancePropertyView> getInstanceModel(Platform.Key platformKey, String modulePath, User user) {
        if (!this.queries.platformExists(platformKey)) {
            throw new PlatformNotFoundException(platformKey);
        }
        return this.queries.getInstanceModel(platformKey, modulePath, user);
    }

    public List<AbstractValuedPropertyView> saveProperties(Platform.Key platformKey, String path, Long platformVersionId, List<AbstractValuedProperty> abstractValuedProperties, User user) {
        Optional platformId = this.queries.getOptionalPlatformId(platformKey);
        if (!platformId.isPresent()) {
            throw new PlatformNotFoundException(platformKey);
        }
        if (ROOT_PATH.equals(path)) {
            List valuedProperties = AbstractValuedProperty.filterAbstractValuedPropertyWithType(abstractValuedProperties, ValuedProperty.class);
            if (valuedProperties.size() != abstractValuedProperties.size()) {
                throw new IllegalArgumentException("Global properties should always be valued properties");
            }
            this.commands.savePlatformProperties((String)platformId.get(), platformVersionId, valuedProperties, user);
        } else {
            Module.Key moduleKey = Module.Key.fromPath((String)path);
            if (!this.moduleQueries.moduleExists((TemplateContainer.Key)moduleKey)) {
                throw new ModuleNotFoundException((TemplateContainer.Key)moduleKey);
            }
            this.commands.saveModulePropertiesInPlatform((String)platformId.get(), path, platformVersionId, abstractValuedProperties, user);
        }
        return this.getProperties(platformKey, path, user);
    }

    public Map<String, Set<GlobalPropertyUsageView>> getGlobalPropertiesUsage(Platform.Key platformKey) {
        return this.queries.getOptionalPlatform(platformKey).map(platformView -> platformView.getGlobalProperties().stream().collect(Collectors.toMap(AbstractValuedPropertyView::getName, globalProperty -> this.getGlobalPropertyUsage(platformView.getDeployedModules(), (ValuedPropertyView)globalProperty)))).orElseThrow(() -> new PlatformNotFoundException(platformKey));
    }

    private Set<GlobalPropertyUsageView> getGlobalPropertyUsage(List<DeployedModuleView> deployedModules, ValuedPropertyView globalProperty) {
        HashSet<GlobalPropertyUsageView> globalPropertyUsage = new HashSet<GlobalPropertyUsageView>();
        deployedModules.forEach(deployedModule -> {
            TemplateContainer.Key moduleKey = deployedModule.getModuleKey();
            ArrayList flatModuleProperties = new ArrayList();
            boolean moduleExists = this.moduleQueries.moduleExists(moduleKey);
            if (moduleExists) {
                List moduleProperties = this.moduleQueries.getProperties(moduleKey);
                flatModuleProperties.addAll(AbstractPropertyView.flattenProperties((List)moduleProperties));
                List moduleGlobalProperties = GlobalPropertyUsageView.getModuleGlobalProperties(flatModuleProperties, (String)globalProperty.getName(), (String)deployedModule.getPropertiesPath());
                globalPropertyUsage.addAll(moduleGlobalProperties);
            }
            List deployedModuleGlobalProperties = GlobalPropertyUsageView.getDeployedModuleGlobalProperties((DeployedModuleView)deployedModule, (String)globalProperty.getName(), flatModuleProperties, (boolean)moduleExists);
            globalPropertyUsage.addAll(deployedModuleGlobalProperties);
        });
        return globalPropertyUsage;
    }
}

