/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.jpa.event.internal.CallbackBuilderLegacyImpl;
import org.hibernate.jpa.event.internal.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.CallbackRegistryImplementor;
import org.hibernate.jpa.event.internal.EmptyCallbackBuilder;
import org.hibernate.jpa.event.internal.EmptyCallbackRegistryImpl;
import org.hibernate.jpa.event.spi.CallbackBuilder;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;

public final class CallbacksFactory {
    public static CallbackRegistryImplementor buildCallbackRegistry(SessionFactoryOptions options) {
        if (CallbacksFactory.jpaCallBacksEnabled(options)) {
            return new CallbackRegistryImpl();
        }
        return new EmptyCallbackRegistryImpl();
    }

    public static CallbackBuilder buildCallbackBuilder(SessionFactoryOptions options, ServiceRegistry serviceRegistry, ReflectionManager reflectionManager) {
        if (CallbacksFactory.jpaCallBacksEnabled(options)) {
            ManagedBeanRegistry managedBeanRegistry = serviceRegistry.getService(ManagedBeanRegistry.class);
            return new CallbackBuilderLegacyImpl(managedBeanRegistry, reflectionManager);
        }
        return new EmptyCallbackBuilder();
    }

    private static boolean jpaCallBacksEnabled(SessionFactoryOptions options) {
        return options.areJPACallbacksEnabled();
    }
}

