/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.type.LocalDateType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class LocalDateJavaDescriptor
extends AbstractTypeDescriptor<LocalDate> {
    public static final LocalDateJavaDescriptor INSTANCE = new LocalDateJavaDescriptor();

    public LocalDateJavaDescriptor() {
        super(LocalDate.class, (MutabilityPlan)ImmutableMutabilityPlan.INSTANCE);
    }

    public String toString(LocalDate value) {
        return LocalDateType.FORMATTER.format(value);
    }

    public LocalDate fromString(String string) {
        return (LocalDate)LocalDateType.FORMATTER.parse(string);
    }

    public <X> X unwrap(LocalDate value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (java.sql.Date.class.isAssignableFrom(type)) {
            return (X)java.sql.Date.valueOf(value);
        }
        LocalDateTime localDateTime = value.atStartOfDay();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(localDateTime);
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (Date.class.equals(type)) {
            return (X)Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    public <X> LocalDate wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isInstance(value)) {
            return (LocalDate)value;
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            return LocalDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        if (Long.class.isInstance(value)) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalDate();
        }
        if (Date.class.isInstance(value)) {
            Date ts = (Date)value;
            Instant instant = Instant.ofEpochMilli(ts.getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
        throw this.unknownWrap(value.getClass());
    }
}

