/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.tika;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TikaBridge;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TikaMetadataProcessor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.Assert;

public class TikaBridgeTest
extends SearchTestCase {
    private static final String TEST_MP3_DOCUMENT = "/org/hibernate/search/test/bridge/tika/mysong.mp3";
    private static final String PATH_TO_TEST_MP3;

    public void testIndexMp3MetaTags() throws Exception {
        Session session = this.openSession();
        this.persistSong(session);
        this.searchSong(session);
        session.close();
    }

    public void testIndexMp3MetaTagsDSL() throws Exception {
        Session session = this.openSession();
        this.persistSong(session);
        this.searchSongDsl(session);
        session.close();
    }

    public void testIndexMp3MetaTagsDSLErrorMessage() throws Exception {
        Session session = this.openSession();
        this.persistSong(session);
        this.searchSongDsl(session);
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnsupportedTypeForTikaBridge() throws Exception {
        Session session = this.openSession();
        try {
            Transaction tx = session.beginTransaction();
            session.save((Object)new Foo());
            tx.commit();
            TikaBridgeTest.fail();
        }
        catch (HibernateException e) {
            TikaBridgeTest.assertTrue((boolean)(e.getCause() instanceof BridgeException));
            BridgeException bridgeException = (BridgeException)e.getCause();
            TikaBridgeTest.assertTrue((boolean)(e.getCause() instanceof SearchException));
            SearchException searchException = (SearchException)bridgeException.getCause();
            TikaBridgeTest.assertTrue((String)"Wrong root cause", (boolean)searchException.getMessage().startsWith("HSEARCH000151"));
        }
        finally {
            session.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class, Song.class};
    }

    private void persistSong(Session session) {
        Transaction tx = session.beginTransaction();
        Song mySong = new Song(PATH_TO_TEST_MP3);
        session.save((Object)mySong);
        tx.commit();
    }

    private void searchSong(Session session) throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction tx = session.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), XMPDM.ARTIST.getName(), TestConstants.standardAnalyzer);
        Query query = parser.parse("Emmanuel");
        List result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        TikaBridgeTest.assertEquals((String)"Emmanuel is not an artist", (int)0, (int)result.size());
        query = parser.parse("Hardy");
        result = fullTextSession.createFullTextQuery(query, new Class[0]).list();
        TikaBridgeTest.assertEquals((String)"Hardy is the artist", (int)1, (int)result.size());
        tx.commit();
    }

    private void searchSongDsl(Session session) throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction tx = session.beginTransaction();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Song.class).get();
        Query queryEmmanuel = ((TermMatchingContext)queryBuilder.keyword().onField("mp3FileName").ignoreFieldBridge()).matching((Object)"Emmanuel").createQuery();
        List result = fullTextSession.createFullTextQuery(queryEmmanuel, new Class[0]).list();
        TikaBridgeTest.assertEquals((String)"Emmanuel is not an artist", (int)0, (int)result.size());
        Query queryHardy = ((TermMatchingContext)queryBuilder.keyword().onField("mp3FileName").ignoreFieldBridge()).matching((Object)"Hardy").createQuery();
        result = fullTextSession.createFullTextQuery(queryHardy, new Class[0]).list();
        TikaBridgeTest.assertEquals((String)"Hardy is the artist", (int)1, (int)result.size());
        tx.commit();
    }

    @TestForIssue(jiraKey="HSEARCH-1256")
    private void searchSongDslErrorMessage(Session session) throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction tx = session.beginTransaction();
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Song.class).get();
        boolean exceptionCaught = false;
        try {
            ((TermMatchingContext)queryBuilder.keyword().onField("mp3FileName").ignoreFieldBridge()).matching((Object)"Emmanuel").createQuery();
        }
        catch (Exception e) {
            exceptionCaught = true;
            Assert.assertTrue((boolean)(e instanceof SearchException));
            Assert.assertTrue((boolean)e.getMessage().contains("The FieldBridge must be a TwoWayFieldBridge or you have to enable the ignoreFieldBridge option when defining a Query"));
        }
        Assert.assertTrue((boolean)exceptionCaught);
        tx.commit();
    }

    static {
        try {
            File mp3File = new File(TikaBridgeTest.class.getResource(TEST_MP3_DOCUMENT).toURI());
            PATH_TO_TEST_MP3 = mp3File.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to determine file path for test document");
        }
    }

    public static class Mp3TikaMetadataProcessor
    implements TikaMetadataProcessor {
        public Metadata prepareMetadata() {
            return new Metadata();
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions, Metadata metadata) {
            luceneOptions.addFieldToDocument(XMPDM.ARTIST.getName(), metadata.get(XMPDM.ARTIST), document);
        }
    }

    @Entity
    @Indexed
    public static class Song {
        @Id
        @GeneratedValue
        long id;
        @Field
        @TikaBridge(metadataProcessor=Mp3TikaMetadataProcessor.class)
        String mp3FileName;

        public Song(String mp3FileName) {
            this.mp3FileName = mp3FileName;
        }

        public String getMp3FileName() {
            return this.mp3FileName;
        }
    }

    @Entity
    @Indexed
    public static class Foo {
        @Id
        @GeneratedValue
        long id;
        @Field
        @TikaBridge
        Date now = new Date();

        public long getId() {
            return this.id;
        }

        public Date getNow() {
            return this.now;
        }
    }
}

