/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.envers;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.envers.Audited;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.envers.Person;

@Entity
@Indexed
@Audited(withModifiedFlag=true)
public class Address {
    @Id
    @GeneratedValue
    @DocumentId
    private Long id;
    @Field
    private String streetName;
    @Field
    private Integer houseNumber;
    @Field
    private Integer flatNumber;
    @OneToMany(mappedBy="address")
    private Set<Person> persons;

    public Address() {
    }

    public Address(String streetName, Integer houseNumber) {
        this.streetName = streetName;
        this.houseNumber = houseNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public Integer getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(Integer houseNumber) {
        this.houseNumber = houseNumber;
    }

    public Integer getFlatNumber() {
        return this.flatNumber;
    }

    public void setFlatNumber(Integer flatNumber) {
        this.flatNumber = flatNumber;
    }

    public Set<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(Set<Person> persons) {
        this.persons = persons;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flatNumber == null ? 0 : this.flatNumber.hashCode());
        result = 31 * result + (this.houseNumber == null ? 0 : this.houseNumber.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.persons == null ? 0 : ((Object)this.persons).hashCode());
        result = 31 * result + (this.streetName == null ? 0 : this.streetName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.flatNumber == null ? other.flatNumber != null : !this.flatNumber.equals(other.flatNumber)) {
            return false;
        }
        if (this.houseNumber == null ? other.houseNumber != null : !this.houseNumber.equals(other.houseNumber)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.persons == null ? other.persons != null : !((Object)this.persons).equals(other.persons)) {
            return false;
        }
        return !(this.streetName == null ? other.streetName != null : !this.streetName.equals(other.streetName));
    }
}

