/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.id.Article;

public class ExplicitIdTest
extends SearchTestCase {
    public void testExplicitDocumentIdSingleResult() throws Exception {
        Article hello = new Article();
        hello.setDocumentId(1);
        hello.setText("Hello World");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)hello);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("text", "world")), new Class[0]).list();
        ExplicitIdTest.assertEquals((int)1, (int)results.size());
        tx.commit();
        s.close();
    }

    public void testExplicitDocumentIdMultipleResults() throws Exception {
        Article hello = new Article();
        hello.setDocumentId(1);
        hello.setText("Hello World");
        Article goodbye = new Article();
        goodbye.setDocumentId(2);
        goodbye.setText("Goodbye World");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)hello);
        s.save((Object)goodbye);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("text", "world")), new Class[0]).list();
        ExplicitIdTest.assertEquals((int)2, (int)results.size());
        tx.commit();
        s.close();
    }

    public void testDocumentIdMustBeUnique() throws Exception {
        Article hello = new Article();
        hello.setDocumentId(1);
        hello.setText("Hello World");
        Article goodbye = new Article();
        goodbye.setDocumentId(1);
        goodbye.setText("Goodbye World");
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)hello);
        s.save((Object)goodbye);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        try {
            Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("text", "world")), new Class[0]).list();
            ExplicitIdTest.fail((String)"Test should fail, because document id is not unique.");
        }
        catch (SearchException e) {
            ExplicitIdTest.assertEquals((String)"Loading entity of type org.hibernate.search.test.id.Article using 'documentId' as document id and '1' as value was not unique", (String)e.getMessage());
        }
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Article.class};
    }
}

