/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={Component.class})
public class TestDelayFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    private boolean injectionDone = false;
    private Control control;

    @Inject
    public void inject(Control control) throws InterruptedException {
        this.control = control;
        control.await();
        this.injectionDone = true;
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.injectionDone) {
            throw new IllegalStateException("GlobalConfiguration reference is null");
        }
        return componentType.cast(new Component());
    }

    @Scope(value=Scopes.GLOBAL)
    public static class Control {
        private final CountDownLatch latch = new CountDownLatch(1);

        public void await() throws InterruptedException {
            this.latch.await(10L, TimeUnit.SECONDS);
        }

        public void unblock() {
            this.latch.countDown();
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    public static class Component {
    }
}

