package org.infinispan.jcache.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.cache.configuration.Configuration;
import javax.cache.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.Closeable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.infinispan.jcache.logging.Log.LeakDescription;
import javax.cache.processor.EntryProcessorException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.ClassCastException;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-10-24T06:58:08-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cacheManagerNotClosed$str() {
        return "ISPN021001: Allocation stack trace:";
    }
    @Override
    public final LeakDescription cacheManagerNotClosed() {
        final LeakDescription result = new LeakDescription(String.format(getLoggingLocale(), cacheManagerNotClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void leakedCacheManager(final Throwable allocationStackTrace) {
        super.log.logf(FQCN, WARN, allocationStackTrace, leakedCacheManager$str());
    }
    protected String leakedCacheManager$str() {
        return "ISPN021002: Closing leaked cache manager";
    }
    protected String methodWithoutCacheAnnotation$str() {
        return "ISPN021003: Method named '%s' is not annotated with CacheResult, CachePut, CacheRemoveEntry or CacheRemoveAll";
    }
    @Override
    public final IllegalArgumentException methodWithoutCacheAnnotation(final String methodName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), methodWithoutCacheAnnotation$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cachePutMethodWithoutCacheValueParameter$str() {
        return "ISPN021004: Method named '%s' must have at least one parameter annotated with @CacheValue";
    }
    @Override
    public final CacheException cachePutMethodWithoutCacheValueParameter(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cachePutMethodWithoutCacheValueParameter$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cachePutMethodWithMoreThanOneCacheValueParameter$str() {
        return "ISPN021005: Method named '%s' must have only one parameter annotated with @CacheValue";
    }
    @Override
    public final CacheException cachePutMethodWithMoreThanOneCacheValueParameter(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cachePutMethodWithMoreThanOneCacheValueParameter$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheRemoveEntryMethodWithoutCacheName$str() {
        return "ISPN021006: Method named '%s' is annotated with CacheRemoveEntry but doesn't specify a cache name";
    }
    @Override
    public final CacheException cacheRemoveEntryMethodWithoutCacheName(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheRemoveEntryMethodWithoutCacheName$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheRemoveAllMethodWithoutCacheName$str() {
        return "ISPN021007: Method named '%s' is annotated with CacheRemoveAll but doesn't specify a cache name";
    }
    @Override
    public final CacheException cacheRemoveAllMethodWithoutCacheName(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheRemoveAllMethodWithoutCacheName$str(), methodName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateCacheKeyGenerator$str() {
        return "ISPN021008: Unable to instantiate CacheKeyGenerator with type '%s'";
    }
    @Override
    public final CacheException unableToInstantiateCacheKeyGenerator(final Class<?> type, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToInstantiateCacheKeyGenerator$str(), type), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterMustNotBeNull$str() {
        return "ISPN021010: '%s' parameter must not be null";
    }
    @Override
    public final NullPointerException parameterMustNotBeNull(final String parameterName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), parameterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleType$str() {
        return "ISPN021011: Incompatible cache value types specified, expected %s but %s was specified";
    }
    @Override
    public final ClassCastException incompatibleType(final Class<?> type, final Class<?> cfgType) {
        final ClassCastException result = new ClassCastException(String.format(getLoggingLocale(), incompatibleType$str(), type, cfgType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheAlreadyRegistered$str() {
        return "ISPN021015: Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s";
    }
    @Override
    public final CacheException cacheAlreadyRegistered(final String cacheName, final Configuration cacheCfg, final Configuration newCfg) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheAlreadyRegistered$str(), cacheName, cacheCfg, newCfg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownExpiryOperation$str() {
        return "ISPN021016: Unknown expiry operation: %s";
    }
    @Override
    public final IllegalStateException unknownExpiryOperation(final String op) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownExpiryOperation$str(), op));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configurationClassNotSupported$str() {
        return "ISPN021018: The configuration class %s is not supported by this implementation";
    }
    @Override
    public final IllegalArgumentException configurationClassNotSupported(final Class clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), configurationClassNotSupported$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String entryProcessingFailed$str() {
        return "ISPN021019: Entry processing failed";
    }
    @Override
    public final EntryProcessorException entryProcessingFailed(final Throwable t) {
        final EntryProcessorException result = new EntryProcessorException(String.format(getLoggingLocale(), entryProcessingFailed$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheNotFound$str() {
        return "ISPN021022: Cache named '%s' was not found.";
    }
    @Override
    public final CacheException cacheNotFound(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheNotFound$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheClosed$str() {
        return "ISPN021023: Cache is closed.";
    }
    @Override
    public final IllegalStateException cacheClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheManagerClosed$str() {
        return "ISPN021030: Cache manager is already closed.";
    }
    @Override
    public final IllegalStateException cacheManagerClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheManagerClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorClosingCloseable(final Closeable closeable, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorClosingCloseable$str(), closeable);
    }
    protected String errorClosingCloseable$str() {
        return "ISPN021031: Error closing %s";
    }
    @Override
    public final void getExpiryHasThrown(final Throwable t) {
        super.log.logf(FQCN, WARN, t, getExpiryHasThrown$str());
    }
    protected String getExpiryHasThrown$str() {
        return "ISPN021032: Exception while getting expiry duration. Fallback to default duration eternal.";
    }
    protected String unableToInstantiateCacheResolverFactory$str() {
        return "ISPN021033: Unable to instantiate CacheResolverFactory with type '%s'";
    }
    @Override
    public final CacheException unableToInstantiateCacheResolverFactory(final Class<?> type, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToInstantiateCacheResolverFactory$str(), type), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
