/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.ChangesByCommit;
import org.javers.core.ChangesByObject;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.metamodel.object.GlobalId;

public class Changes
extends AbstractList<Change> {
    private final List<Change> changes;
    private final transient PrettyValuePrinter valuePrinter;

    public Changes(List<Change> changes, PrettyValuePrinter valuePrinter) {
        ImmutableMap string = ImmutableMap.of((Object)"a", (Object)"b", (Object)"c", (Object)"d");
        Validate.argumentsAreNotNull(changes, valuePrinter);
        this.changes = changes;
        this.valuePrinter = valuePrinter;
    }

    public List<ChangesByCommit> groupByCommit() {
        Map changesByCommit = this.changes.stream().collect(Collectors.groupingBy(c -> c.getCommitMetadata().orElseThrow(() -> new IllegalStateException("No CommitMetadata in this Change")), () -> new LinkedHashMap(), Collectors.toList()));
        ArrayList result = new ArrayList();
        changesByCommit.forEach((? super K k, ? super V v) -> result.add(new ChangesByCommit((CommitMetadata)k, (List<Change>)v, this.valuePrinter)));
        return Collections.unmodifiableList(result);
    }

    public List<ChangesByObject> groupByObject() {
        Map<GlobalId, List<Change>> changesByObject = this.changes.stream().collect(Collectors.groupingBy(c -> c.getAffectedGlobalId().masterObjectId()));
        ArrayList result = new ArrayList();
        changesByObject.forEach((? super K k, ? super V v) -> result.add(new ChangesByObject((GlobalId)k, (List<Change>)v, this.valuePrinter)));
        return Collections.unmodifiableList(result);
    }

    @Override
    public Change get(int index) {
        return this.changes.get(index);
    }

    @Override
    public int size() {
        return this.changes.size();
    }

    public final String prettyPrint() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Changes:\n");
        for (ChangesByCommit c : this.groupByCommit()) {
            b.append(c.prettyPrint());
        }
        return b.toString();
    }
}

