/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;

public class CommitMetadata
implements Serializable {
    private final String author;
    private final Map<String, String> properties;
    private final LocalDateTime commitDate;
    private final CommitId id;

    public CommitMetadata(String author, Map<String, String> properties, LocalDateTime commitDate, CommitId id) {
        Validate.argumentsAreNotNull(author, properties, commitDate, id);
        this.author = author;
        this.properties = new HashMap<String, String>(properties);
        this.commitDate = commitDate;
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public LocalDateTime getCommitDate() {
        return this.commitDate;
    }

    public CommitId getId() {
        return this.id;
    }

    public boolean isBeforeOrEqual(CommitMetadata that) {
        return this.id.isBeforeOrEqual(that.id);
    }

    public String toString() {
        return ToStringBuilder.toString(this, "author", this.author, "properties", this.properties, "util", this.commitDate, "id", this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitMetadata that = (CommitMetadata)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

