/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.ChangesByObject;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;

public class Diff
implements Serializable {
    private final List<Change> changes;
    private final transient PrettyValuePrinter valuePrinter;

    Diff(List<Change> changes, PrettyValuePrinter valuePrinter) {
        this.changes = changes;
        this.valuePrinter = valuePrinter;
    }

    public <C extends Change> List getObjectsByChangeType(Class<C> type) {
        Validate.argumentIsNotNull(type);
        return Lists.transform(this.getChangesByType(type), input -> input.getAffectedObject().orElseThrow(() -> new JaversException(JaversExceptionCode.AFFECTED_CDO_IS_NOT_AVAILABLE, new Object[0])));
    }

    public List getObjectsWithChangedProperty(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return Lists.transform(this.getPropertyChanges(propertyName), input -> input.getAffectedObject().orElseThrow(() -> new JaversException(JaversExceptionCode.AFFECTED_CDO_IS_NOT_AVAILABLE, new Object[0])));
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public List<ChangesByObject> groupByObject() {
        return new Changes(this.changes, this.valuePrinter).groupByObject();
    }

    public List<Change> getChanges(Predicate<Change> predicate) {
        return Lists.positiveFilter(this.changes, predicate);
    }

    public <C extends Change> List<C> getChangesByType(Class<C> type) {
        Validate.argumentIsNotNull(type);
        return this.getChanges(input -> type.isAssignableFrom(input.getClass()));
    }

    public List<PropertyChange> getPropertyChanges(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        return this.getChanges(input -> input instanceof PropertyChange && ((PropertyChange)input).getPropertyName().equals(propertyName));
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public final String prettyPrint() {
        return this.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Diff:\n");
        this.groupByObject().forEach(it -> b.append(it.toString()));
        return b.toString();
    }

    public String changesSummary() {
        StringBuilder b = new StringBuilder();
        b.append("changes - ");
        for (Map.Entry<Class<? extends Change>, Integer> e : this.countByType().entrySet()) {
            b.append(e.getKey().getSimpleName() + ":" + e.getValue() + " ");
        }
        return b.toString().trim();
    }

    public Map<Class<? extends Change>, Integer> countByType() {
        HashMap<Class<? extends Change>, Integer> result = new HashMap<Class<? extends Change>, Integer>();
        for (Change change : this.changes) {
            Class<?> key = change.getClass();
            if (result.containsKey(change.getClass())) {
                result.put(key, (Integer)result.get(key) + 1);
                continue;
            }
            result.put(key, 1);
        }
        return result;
    }
}

