/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Objects;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.ReferenceChange;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.TypeMapper;

public class OptionalChangeAppender
extends CorePropertyChangeAppender<PropertyChange> {
    private final GlobalIdFactory globalIdFactory;
    private final TypeMapper typeMapper;

    public OptionalChangeAppender(GlobalIdFactory globalIdFactory, TypeMapper typeMapper) {
        this.globalIdFactory = globalIdFactory;
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof OptionalType;
    }

    @Override
    public PropertyChange calculateChanges(NodePair pair, JaversProperty property) {
        OptionalType optionalType = (OptionalType)property.getType();
        JaversType contentType = this.typeMapper.getJaversType(optionalType.getItemType());
        Optional leftOptional = this.normalize((Optional)pair.getLeftPropertyValue(property));
        Optional rightOptional = this.normalize((Optional)pair.getRightPropertyValue(property));
        if (contentType instanceof ManagedType) {
            GlobalId rightId;
            GlobalId leftId = this.getAndDehydrate(leftOptional, contentType);
            if (Objects.equals(leftId, rightId = this.getAndDehydrate(rightOptional, contentType))) {
                return null;
            }
            return new ReferenceChange(pair.getGlobalId(), property.getName(), leftId, rightId, pair.getLeftPropertyValue(property), pair.getRightPropertyValue(property));
        }
        if (contentType instanceof PrimitiveOrValueType) {
            if (leftOptional.equals(rightOptional)) {
                return null;
            }
            return new ValueChange(pair.getGlobalId(), property.getName(), leftOptional, rightOptional);
        }
        throw new JaversException(JaversExceptionCode.UNSUPPORTED_OPTIONAL_CONTENT_TYPE, contentType);
    }

    private GlobalId getAndDehydrate(Optional optional, JaversType contentType) {
        return optional.map(o -> this.globalIdFactory.dehydrate(o, contentType, null)).orElse(null);
    }

    private Optional normalize(Optional optional) {
        if (optional == null) {
            return Optional.empty();
        }
        return optional;
    }
}

