/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.EdgeBuilder;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private final TypeMapper typeMapper;
    private boolean built;
    private final EdgeBuilder edgeBuilder;
    private final NodeReuser nodeReuser = new NodeReuser();
    private final CdoFactory cdoFactory;

    public ObjectGraphBuilder(TypeMapper typeMapper, CdoFactory cdoFactory) {
        Validate.argumentsAreNotNull(typeMapper, cdoFactory);
        this.typeMapper = typeMapper;
        this.cdoFactory = cdoFactory;
        this.edgeBuilder = new EdgeBuilder(typeMapper, this.nodeReuser, cdoFactory);
    }

    public LiveGraph buildGraph(Object handle) {
        Validate.argumentIsNotNull(handle);
        Cdo cdo = this.cdoFactory.create(handle, null);
        return this.buildGraphFromCdo(cdo);
    }

    LiveGraph buildGraphFromCdo(Cdo cdo) {
        Validate.argumentIsNotNull(cdo);
        ObjectNode root = this.edgeBuilder.buildNodeStub(cdo);
        while (this.nodeReuser.hasMoreStubs()) {
            ObjectNode stub = this.nodeReuser.pollStub();
            this.buildEdges(stub);
        }
        logger.debug("{} graph assembled, object nodes: {}, entities: {}, valueObjects: {}", new Object[]{this.edgeBuilder.graphType(), this.nodeReuser.nodesCount(), this.nodeReuser.entitiesCount(), this.nodeReuser.voCount()});
        this.switchToBuilt();
        return new LiveGraph(root, this.nodeReuser.nodes());
    }

    private void buildEdges(ObjectNode nodeStub) {
        this.nodeReuser.saveForReuse(nodeStub);
        this.buildSingleEdges(nodeStub);
        this.buildMultiEdges(nodeStub);
    }

    private void buildSingleEdges(ObjectNode node) {
        for (JaversProperty singleRef : this.getSingleReferencesWithManagedTypes(node.getManagedType())) {
            if (node.isNull(singleRef)) continue;
            AbstractSingleEdge edge = this.edgeBuilder.buildSingleEdge(node, singleRef);
            node.addEdge(edge);
        }
    }

    private void buildMultiEdges(ObjectNode node) {
        for (JaversProperty containerProperty : this.getNonEmptyEnumerablesWithManagedTypes(node)) {
            EnumerableType enumerableType = (EnumerableType)containerProperty.getType();
            MultiEdge multiEdge = this.edgeBuilder.createMultiEdge(containerProperty, enumerableType, node);
            node.addEdge(multiEdge);
        }
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is a stateful builder (not a Service)");
        }
        this.built = true;
    }

    private List<JaversProperty> getSingleReferencesWithManagedTypes(ManagedType managedType) {
        return managedType.getProperties(property -> property.getType() instanceof ManagedType);
    }

    private List<JaversProperty> getNonEmptyEnumerablesWithManagedTypes(ObjectNode node) {
        return node.getManagedType().getProperties(property -> {
            Object container;
            if (!(property.getType() instanceof EnumerableType)) {
                return false;
            }
            EnumerableType enumerableType = (EnumerableType)property.getType();
            if (enumerableType.isEmpty(container = node.getPropertyValue((Property)property))) {
                return false;
            }
            if (node.isNull((Property)property)) {
                return false;
            }
            return this.typeMapper.isContainerOfManagedTypes(enumerableType) || this.typeMapper.isKeyValueTypeWithManagedTypes(enumerableType);
        });
    }
}

