/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.Objects;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.LiveCdo;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public SnapshotFactory(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    public CdoSnapshot createTerminal(GlobalId globalId, CdoSnapshot previous, CommitMetadata commitMetadata) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(globalId);
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(globalId).withManagedType(managedType).withCommitMetadata(commitMetadata).withType(SnapshotType.TERMINAL).withVersion(previous.getVersion() + 1L).build();
    }

    public CdoSnapshot createInitial(LiveCdo liveCdo, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(liveCdo, commitMetadata).withState(this.createSnapshotState(liveCdo)).withType(SnapshotType.INITIAL).markAllAsChanged().withVersion(1L).build();
    }

    public CdoSnapshot createUpdate(LiveCdo liveCdo, CdoSnapshot previous, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(liveCdo, commitMetadata).withState(this.createSnapshotState(liveCdo)).withType(SnapshotType.UPDATE).markChanged(previous).withVersion(previous.getVersion() + 1L).build();
    }

    public CdoSnapshotState createSnapshotState(LiveCdo liveCdo) {
        CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
        for (JaversProperty property : liveCdo.getManagedType().getProperties()) {
            Object propertyVal = liveCdo.getPropertyValue(property.getName());
            if (Objects.equals(propertyVal, Defaults.defaultValue(property.getGenericType()))) continue;
            stateBuilder.withPropertyValue(property, this.dehydrateProperty(property, propertyVal, liveCdo.getGlobalId()));
        }
        return stateBuilder.build();
    }

    private Object extractAndDehydrateEnumerable(Object propertyVal, EnumerableType propertyType, OwnerContext owner) {
        EnumerableFunction dehydratorMapFunction;
        if (propertyType instanceof ContainerType) {
            JaversType itemType = this.typeMapper.getJaversType(((ContainerType)propertyType).getItemClass());
            dehydratorMapFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        } else if (propertyType instanceof KeyValueType) {
            MapContentType mapContentType = this.typeMapper.getMapContentType((KeyValueType)propertyType);
            dehydratorMapFunction = new DehydrateMapFunction(this.globalIdFactory, mapContentType);
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        return propertyType.map(propertyVal, dehydratorMapFunction, owner);
    }

    private CdoSnapshotBuilder initSnapshotBuilder(LiveCdo liveCdo, CommitMetadata commitMetadata) {
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(liveCdo.getGlobalId()).withCommitMetadata(commitMetadata).withManagedType(liveCdo.getManagedType());
    }

    private Object dehydrateProperty(JaversProperty property, Object propertyVal, GlobalId id) {
        PropertyOwnerContext owner = new PropertyOwnerContext(id, property.getName());
        if (property.getType() instanceof EnumerableType) {
            return this.extractAndDehydrateEnumerable(propertyVal, (EnumerableType)property.getType(), owner);
        }
        return this.globalIdFactory.dehydrate(propertyVal, (JaversType)property.getType(), owner);
    }
}

