/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.InvocationTargetException;
import javolution.JavolutionError;
import javolution.util.FastMap;

public final class Reflection {
    private static final FastMap _NameToClass = new FastMap();

    private Reflection() {
    }

    public static Class getClass(CharSequence charSequence) throws ClassNotFoundException {
        Class clazz = (Class)_NameToClass.get(charSequence);
        return clazz != null ? clazz : Reflection.searchClass(((Object)charSequence).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class searchClass(String string) throws ClassNotFoundException {
        Class<?> clazz;
        block7: {
            clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    clazz = Class.forName(string, true, classLoader);
                }
                if (clazz != null) break block7;
                throw new ClassNotFoundException("Cannot found class " + string);
            }
        }
        FastMap fastMap = _NameToClass;
        synchronized (fastMap) {
            _NameToClass.put(string, clazz);
        }
        return clazz;
    }

    public static Class getClass(String string) throws ClassNotFoundException {
        Class clazz = (Class)_NameToClass.get(string);
        return clazz != null ? clazz : Reflection.searchClass(string);
    }

    public static Constructor getConstructor(String string) {
        Class[] classArray;
        Class clazz;
        int n = string.indexOf(40) + 1;
        if (n < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        String string2 = string.substring(0, n - 1);
        try {
            clazz = Reflection.getClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        String string3 = string.substring(n, n2);
        if (string3.length() == 0) {
            return new DefaultConstructor(clazz);
        }
        try {
            classArray = Reflection.classesFor(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return new ReflectConstructor(clazz.getConstructor(classArray), string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethod(String string) {
        int n = string.indexOf(40) + 1;
        if (n < 0) {
            throw new IllegalArgumentException("Parenthesis '(' not found");
        }
        int n2 = string.indexOf(41);
        if (n2 < 0) {
            throw new IllegalArgumentException("Parenthesis ')' not found");
        }
        int n3 = string.substring(0, n).lastIndexOf(46) + 1;
        try {
            Class[] classArray;
            Class clazz;
            String string2 = string.substring(0, n3 - 1);
            try {
                clazz = Reflection.getClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            String string3 = string.substring(n3, n - 1);
            String string4 = string.substring(n, n2);
            try {
                classArray = Reflection.classesFor(string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            return new ReflectMethod(clazz.getMethod(string3, classArray), string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class[] classesFor(String string) throws ClassNotFoundException {
        if ((string = string.trim()).length() == 0) {
            return new Class[0];
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            n2 = string.indexOf(44, n2);
            if (n2++ < 0) break;
            ++n;
        }
        Class[] classArray = new Class[n + 1];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = string.indexOf(44, n3);
            classArray[i] = Reflection.classFor(string.substring(n3, n4).trim());
            if (classArray[i] == null) {
                return null;
            }
            n3 = n4 + 1;
        }
        classArray[n] = Reflection.classFor(string.substring(n3).trim());
        if (classArray[n] == null) {
            return null;
        }
        return classArray;
    }

    private static Class classFor(String string) throws ClassNotFoundException {
        int n = string.indexOf("[]");
        if (n >= 0) {
            if (string.indexOf("[][]") >= 0) {
                if (string.indexOf("[][][]") >= 0) {
                    if (string.indexOf("[][][][]") >= 0) {
                        throw new UnsupportedOperationException("The maximum array dimension is 3");
                    }
                    return Reflection.getClass("[[[" + Reflection.descriptorFor(string.substring(0, n)));
                }
                return Reflection.getClass("[[" + Reflection.descriptorFor(string.substring(0, n)));
            }
            return Reflection.getClass("[" + Reflection.descriptorFor(string.substring(0, n)));
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        return Reflection.getClass(string);
    }

    private static String descriptorFor(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        return "L" + string + ";";
    }

    public static abstract class Method {
        private static final Object[] NO_ARG = new Object[0];
        private final Object[] array1 = new Object[1];
        private final Object[] array2 = new Object[2];
        private final Object[] array3 = new Object[3];
        private final Object[] array4 = new Object[4];

        protected abstract Object execute(Object var1, Object[] var2);

        public final Object invoke(Object object) {
            return this.execute(object, NO_ARG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object object, Object object2) {
            Method method = this;
            synchronized (method) {
                this.array1[0] = object2;
                return this.execute(object, this.array1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object object, Object object2, Object object3) {
            Method method = this;
            synchronized (method) {
                this.array2[0] = object2;
                this.array2[1] = object3;
                return this.execute(object, this.array2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object object, Object object2, Object object3, Object object4) {
            Method method = this;
            synchronized (method) {
                this.array3[0] = object2;
                this.array3[1] = object3;
                this.array3[2] = object4;
                return this.execute(object, this.array3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object invoke(Object object, Object object2, Object object3, Object object4, Object object5) {
            Method method = this;
            synchronized (method) {
                this.array4[0] = object2;
                this.array4[1] = object3;
                this.array4[2] = object4;
                this.array4[3] = object5;
                return this.execute(object, this.array4);
            }
        }
    }

    public static abstract class Constructor {
        private static final Object[] NO_ARG = new Object[0];
        private final Object[] array1 = new Object[1];
        private final Object[] array2 = new Object[2];
        private final Object[] array3 = new Object[3];
        private final Object[] array4 = new Object[4];

        protected abstract Object allocate(Object[] var1);

        public final Object newInstance() {
            return this.allocate(NO_ARG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object object) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array1[0] = object;
                return this.allocate(this.array1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object object, Object object2) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array2[0] = object;
                this.array2[1] = object2;
                return this.allocate(this.array2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object object, Object object2, Object object3) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array3[0] = object;
                this.array3[1] = object2;
                this.array3[2] = object3;
                return this.allocate(this.array3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object newInstance(Object object, Object object2, Object object3, Object object4) {
            Constructor constructor = this;
            synchronized (constructor) {
                this.array4[0] = object;
                this.array4[1] = object2;
                this.array4[2] = object3;
                this.array4[3] = object4;
                return this.allocate(this.array4);
            }
        }
    }

    private static final class ReflectMethod
    extends Method {
        private final java.lang.reflect.Method _value;
        private final String _signature;

        public ReflectMethod(java.lang.reflect.Method method, String string) {
            this._value = method;
            this._signature = string;
        }

        public Object execute(Object object, Object[] objectArray) {
            try {
                return this._value.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JavolutionError("Illegal argument for " + this._signature + " method", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._signature + " method", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JavolutionError("Invocation exception for " + this._signature + " method", (InvocationTargetException)invocationTargetException.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " method";
        }
    }

    private static final class ReflectConstructor
    extends Constructor {
        private final java.lang.reflect.Constructor _value;
        private final String _signature;

        public ReflectConstructor(java.lang.reflect.Constructor constructor, String string) {
            this._value = constructor;
            this._signature = string;
        }

        public Object allocate(Object[] objectArray) {
            try {
                return this._value.newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JavolutionError("Illegal argument for " + this._signature + " constructor", illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new JavolutionError("Instantiation error for " + this._signature + " constructor", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._signature + " constructor", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new JavolutionError("Invocation exception  for " + this._signature + " constructor", (InvocationTargetException)invocationTargetException.getTargetException());
            }
        }

        public String toString() {
            return this._signature + " constructor";
        }
    }

    private static class DefaultConstructor
    extends Constructor {
        final Class _class;

        DefaultConstructor(Class clazz) {
            this._class = clazz;
        }

        public Object allocate(Object[] objectArray) {
            try {
                return this._class.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new JavolutionError("Instantiation error for " + this._class.getName() + " default constructor", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JavolutionError("Illegal access error for " + this._class.getName() + " constructor", illegalAccessException);
            }
        }

        public String toString() {
            return this._class + " default constructor";
        }
    }
}

