/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import javolution.text.TypeFormat;
import javolution.util.FastComparator;

public final class CharArray
implements CharSequence,
Comparable {
    private char[] _array;
    private int _offset;
    private int _length;

    public CharArray() {
    }

    public CharArray(String string) {
        this._array = string.toCharArray();
        this._offset = 0;
        this._length = string.length();
    }

    public CharArray(CharSequence charSequence) {
        this._offset = 0;
        this._length = charSequence.length();
        this._array = new char[this._length];
        int n = 0;
        while (n < this._length) {
            this._array[n] = charSequence.charAt(n++);
        }
    }

    public char[] array() {
        return this._array;
    }

    public int length() {
        return this._length;
    }

    public int offset() {
        return this._offset;
    }

    public void setArray(char[] cArray) {
        this._array = cArray;
    }

    public void setLength(int n) {
        this._length = n;
    }

    public void setOffset(int n) {
        this._offset = n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this._length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return this._array[this._offset + n];
    }

    public CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        CharArray charArray = new CharArray();
        charArray._array = this._array;
        charArray._offset = this._offset + n;
        charArray._length = n2 - n;
        return charArray;
    }

    public final int offsetOf(CharSequence charSequence) {
        char c = charSequence.charAt(0);
        int n = charSequence.length();
        int n2 = this._offset + this._length - n + 1;
        for (int i = this._offset; i < n2; ++i) {
            if (this._array[i] != c) continue;
            boolean bl = true;
            for (int j = 1; j < n; ++j) {
                if (this._array[i + j] == charSequence.charAt(j)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public final int offsetOf(char c) {
        int n = this._offset + this._length;
        for (int i = this._offset; i < n; ++i) {
            if (this._array[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return new String(this._array, this._offset, this._length);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._offset;
        for (int i = 0; i < this._length; ++i) {
            n = 31 * n + this._array[n2++];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CharArray) {
            return this.equals((CharArray)object);
        }
        if (object instanceof String) {
            return this.equals((String)object);
        }
        if (object instanceof CharSequence) {
            return this.equals((CharSequence)object);
        }
        return false;
    }

    private boolean equals(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (this._length != charSequence.length()) {
            return false;
        }
        int n = this._length;
        int n2 = this._offset + this._length;
        while (--n >= 0) {
            if (this._array[--n2] == charSequence.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharArray charArray) {
        if (charArray == null) {
            return false;
        }
        if (this._length != charArray._length) {
            return false;
        }
        char[] cArray = charArray._array;
        int n = charArray._offset + this._length;
        int n2 = this._offset + this._length;
        while (--n2 >= this._offset) {
            if (this._array[n2] == cArray[--n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        if (this._length != string.length()) {
            return false;
        }
        int n = this._length;
        int n2 = this._offset + this._length;
        while (--n >= 0) {
            if (this._array[--n2] == string.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        return FastComparator.LEXICAL.compare(this, object);
    }

    public boolean toBoolean() {
        int n = this._offset;
        if (!(this._length != 4 || this._array[n] != 't' && this._array[n] != 'T' || this._array[++n] != 'r' && this._array[n] != 'R' || this._array[++n] != 'u' && this._array[n] != 'U' || this._array[++n] != 'e' && this._array[n] != 'E')) {
            return true;
        }
        if (!(this._length != 5 || this._array[n] != 'f' && this._array[n] != 'F' || this._array[++n] != 'a' && this._array[n] != 'A' || this._array[++n] != 'l' && this._array[n] != 'L' || this._array[++n] != 's' && this._array[n] != 'S' || this._array[++n] != 'e' && this._array[n] != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + this + " as boolean");
    }

    public int toInt() {
        return TypeFormat.parseInt(this);
    }

    public int toInt(int n) {
        return TypeFormat.parseInt(this, n);
    }

    public long toLong() {
        return TypeFormat.parseLong(this);
    }

    public long toLong(int n) {
        return TypeFormat.parseLong(this, n);
    }

    public float toFloat() {
        return TypeFormat.parseFloat(this);
    }

    public double toDouble() {
        return TypeFormat.parseDouble(this);
    }
}

