/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import javolution.lang.MathLib;
import javolution.text.CharArray;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;

public final class TypeFormat {
    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence charSequence) {
        if (!(charSequence.length() != 4 || charSequence.charAt(0) != 't' && charSequence.charAt(0) != 'T' || charSequence.charAt(1) != 'r' && charSequence.charAt(1) != 'R' || charSequence.charAt(2) != 'u' && charSequence.charAt(2) != 'U' || charSequence.charAt(3) != 'e' && charSequence.charAt(3) != 'E')) {
            return true;
        }
        if (!(charSequence.length() != 5 || charSequence.charAt(0) != 'f' && charSequence.charAt(0) != 'F' || charSequence.charAt(1) != 'a' && charSequence.charAt(1) != 'A' || charSequence.charAt(2) != 'l' && charSequence.charAt(2) != 'L' || charSequence.charAt(3) != 's' && charSequence.charAt(3) != 'S' || charSequence.charAt(4) != 'e' && charSequence.charAt(4) != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + charSequence + " as boolean");
    }

    public static boolean parseBoolean(String string) {
        if (!(string.length() != 4 || string.charAt(0) != 't' && string.charAt(0) != 'T' || string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E')) {
            return true;
        }
        if (!(string.length() != 5 || string.charAt(0) != 'f' && string.charAt(0) != 'F' || string.charAt(1) != 'a' && string.charAt(1) != 'A' || string.charAt(2) != 'l' && string.charAt(2) != 'L' || string.charAt(3) != 's' && string.charAt(3) != 'S' || string.charAt(4) != 'e' && string.charAt(4) != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + string + " as boolean");
    }

    public static boolean parseBoolean(CharSequence charSequence, TextFormat.Cursor cursor) {
        int n = cursor.getIndex();
        if (!(cursor.getEndIndex() <= n + 4 || charSequence.charAt(n) != 't' && charSequence.charAt(n) != 'T' || charSequence.charAt(n + 1) != 'r' && charSequence.charAt(n + 1) != 'R' || charSequence.charAt(n + 2) != 'u' && charSequence.charAt(n + 2) != 'U' || charSequence.charAt(n + 3) != 'e' && charSequence.charAt(n + 3) != 'E')) {
            cursor.increment(4);
            return true;
        }
        if (!(cursor.getEndIndex() <= n + 5 || charSequence.charAt(n) != 'f' && charSequence.charAt(n) != 'F' || charSequence.charAt(n + 1) != 'a' && charSequence.charAt(n + 1) != 'A' || charSequence.charAt(n + 2) != 'l' && charSequence.charAt(n + 2) != 'L' || charSequence.charAt(n + 3) != 's' && charSequence.charAt(n + 3) != 'S' || charSequence.charAt(n + 4) != 'e' && charSequence.charAt(n + 4) != 'E')) {
            cursor.increment(5);
            return false;
        }
        throw new IllegalArgumentException("Cannot parse boolean at " + cursor.getIndex());
    }

    public static byte parseByte(CharSequence charSequence) {
        return TypeFormat.parseByte(charSequence, 10);
    }

    public static byte parseByte(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static byte parseByte(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)n2;
    }

    public static short parseShort(CharSequence charSequence) {
        return TypeFormat.parseShort(charSequence, 10);
    }

    public static short parseShort(CharSequence charSequence, int n) {
        int n2 = TypeFormat.parseInt(charSequence, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static short parseShort(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2 = TypeFormat.parseInt(charSequence, n, cursor);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)n2;
    }

    public static int parseInt(CharSequence charSequence) {
        return TypeFormat.parseInt(charSequence, 10);
    }

    public static int parseInt(String string) {
        return TypeFormat.parseIntString(string, 10, null);
    }

    public static int parseInt(CharSequence charSequence, int n) {
        return TypeFormat.parseInt(charSequence, n, null);
    }

    public static int parseInt(String string, int n) {
        return TypeFormat.parseIntString(string, n, null);
    }

    public static int parseInt(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        if (charSequence instanceof CharArray) {
            return TypeFormat.parseIntCharArray((CharArray)charSequence, n, cursor);
        }
        if (charSequence instanceof TextBuilder) {
            return TypeFormat.parseIntTextBuilder((TextBuilder)charSequence, n, cursor);
        }
        if (charSequence instanceof Text) {
            return TypeFormat.parseIntText((Text)charSequence, n, cursor);
        }
        if (charSequence instanceof String) {
            return TypeFormat.parseIntString((String)charSequence, n, cursor);
        }
        return TypeFormat.parseIntCharSequence(charSequence, n, cursor);
    }

    private static int parseIntCharArray(CharArray charArray, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : charArray.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = charArray.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || charArray.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charArray + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntTextBuilder(TextBuilder textBuilder, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : textBuilder.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = textBuilder.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || textBuilder.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + textBuilder + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntText(Text text, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : text.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = text.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || text.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + text + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntString(String string, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : string.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = string.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || string.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + string + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    private static int parseIntCharSequence(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : charSequence.length();
        boolean bl = false;
        int n5 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            int n6;
            char c = charSequence.charAt(n2);
            int n7 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n6 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n6 >= 0 && n6 < n) {
                int n8 = n5 * n - n6;
                if (n8 > n5) {
                    throw new NumberFormatException("Overflow");
                }
                n5 = n8;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (n5 == 0 && (n4 == 0 || charSequence.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charSequence + " as int");
        }
        if (n5 == Integer.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? n5 : -n5;
    }

    public static long parseLong(CharSequence charSequence) {
        return TypeFormat.parseLong(charSequence, 10);
    }

    public static long parseLong(String string) {
        return TypeFormat.parseLongString(string, 10, null);
    }

    public static long parseLong(CharSequence charSequence, int n) {
        return TypeFormat.parseLong(charSequence, n, null);
    }

    public static long parseLong(String string, int n) {
        return TypeFormat.parseLongString(string, n, null);
    }

    public static long parseLong(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        if (charSequence instanceof CharArray) {
            return TypeFormat.parseLongCharArray((CharArray)charSequence, n, cursor);
        }
        if (charSequence instanceof TextBuilder) {
            return TypeFormat.parseLongTextBuilder((TextBuilder)charSequence, n, cursor);
        }
        if (charSequence instanceof Text) {
            return TypeFormat.parseLongText((Text)charSequence, n, cursor);
        }
        if (charSequence instanceof String) {
            return TypeFormat.parseLongString((String)charSequence, n, cursor);
        }
        return TypeFormat.parseLongCharSequence(charSequence, n, cursor);
    }

    private static long parseLongCharArray(CharArray charArray, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : charArray.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = charArray.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || charArray.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charArray + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongTextBuilder(TextBuilder textBuilder, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : textBuilder.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = textBuilder.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || textBuilder.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + textBuilder + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongText(Text text, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : text.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = text.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || text.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + text + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongString(String string, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : string.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = string.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || string.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + string + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    private static long parseLongCharSequence(CharSequence charSequence, int n, TextFormat.Cursor cursor) {
        int n2;
        int n3 = cursor != null ? cursor.getIndex() : 0;
        int n4 = cursor != null ? cursor.getEndIndex() : charSequence.length();
        boolean bl = false;
        long l = 0L;
        for (n2 = n3; n2 < n4; ++n2) {
            int n5;
            char c = charSequence.charAt(n2);
            int n6 = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (n5 = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
            if (n5 >= 0 && n5 < n) {
                long l2 = l * (long)n - (long)n5;
                if (l2 > l) {
                    throw new NumberFormatException("Overflow");
                }
                l = l2;
                continue;
            }
            if (c == '-' && n2 == n3) {
                bl = true;
                continue;
            }
            if (c == '+' && n2 == n3) continue;
            if (cursor != null) break;
            throw new NumberFormatException("Incomplete parsing");
        }
        if (l == 0L && (n4 == 0 || charSequence.charAt(n2 - 1) != '0')) {
            throw new NumberFormatException("Cannot parse " + charSequence + " as int");
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("Overflow");
        }
        if (cursor != null) {
            cursor.setIndex(n2);
        }
        return bl ? l : -l;
    }

    public static float parseFloat(CharSequence charSequence) {
        return (float)TypeFormat.parseDouble(charSequence);
    }

    public static float parseFloat(String string) {
        return (float)TypeFormat.parseDoubleString(string, null);
    }

    public static float parseFloat(CharSequence charSequence, TextFormat.Cursor cursor) {
        return (float)TypeFormat.parseDouble(charSequence, cursor);
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        return TypeFormat.parseDouble(charSequence, null);
    }

    public static double parseDouble(String string) {
        return TypeFormat.parseDoubleString(string, null);
    }

    public static double parseDouble(CharSequence charSequence, TextFormat.Cursor cursor) throws NumberFormatException {
        if (charSequence instanceof CharArray) {
            return TypeFormat.parseDoubleCharArray((CharArray)charSequence, cursor);
        }
        if (charSequence instanceof TextBuilder) {
            return TypeFormat.parseDoubleTextBuilder((TextBuilder)charSequence, cursor);
        }
        if (charSequence instanceof Text) {
            return TypeFormat.parseDoubleText((Text)charSequence, cursor);
        }
        if (charSequence instanceof String) {
            return TypeFormat.parseDoubleString((String)charSequence, cursor);
        }
        return TypeFormat.parseDoubleCharSequence(charSequence, cursor);
    }

    private static double parseDoubleCharArray(CharArray charArray, TextFormat.Cursor cursor) throws NumberFormatException {
        int n;
        boolean bl;
        int n2 = cursor != null ? cursor.getIndex() : 0;
        int n3 = cursor != null ? cursor.getEndIndex() : charArray.length();
        int n4 = n2;
        char c = charArray.charAt(n4);
        if (c == 'N' && TypeFormat.match("NaN", charArray, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 3);
            }
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n3) {
            c = charArray.charAt(n4);
        }
        if (c == 'I' && TypeFormat.match("Infinity", charArray, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 8);
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n = c - 48) >= 0 && n < 10) {
                long l2 = l * 10L + (long)n;
                if (l2 < l) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                l = l2;
            } else {
                if (c != '.') break;
                n5 = n4;
            }
            if (++n4 >= n3) break;
            c = charArray.charAt(n4);
        }
        if (bl) {
            l = -l;
        }
        n = n5 >= 0 ? n4 - n5 - 1 : 0;
        int n6 = 0;
        if (n4 < n3 && (c == 'E' || c == 'e')) {
            int n7;
            boolean bl3;
            boolean bl4 = bl3 = (c = charArray.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n3) {
                c = charArray.charAt(n4);
            }
            while ((n7 = c - 48) >= 0 && n7 < 10) {
                int n8 = n6 * 10 + n7;
                if (n8 < n6) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                n6 = n8;
                if (++n4 >= n3) break;
                c = charArray.charAt(n4);
            }
            if (bl3) {
                n6 = -n6;
            }
        }
        if (cursor != null) {
            cursor.setIndex(n4);
        }
        return MathLib.toDoublePow10(l, n6 - n);
    }

    private static double parseDoubleTextBuilder(TextBuilder textBuilder, TextFormat.Cursor cursor) throws NumberFormatException {
        int n;
        boolean bl;
        int n2 = cursor != null ? cursor.getIndex() : 0;
        int n3 = cursor != null ? cursor.getEndIndex() : textBuilder.length();
        int n4 = n2;
        char c = textBuilder.charAt(n4);
        if (c == 'N' && TypeFormat.match("NaN", textBuilder, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 3);
            }
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n3) {
            c = textBuilder.charAt(n4);
        }
        if (c == 'I' && TypeFormat.match("Infinity", textBuilder, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 8);
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n = c - 48) >= 0 && n < 10) {
                long l2 = l * 10L + (long)n;
                if (l2 < l) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                l = l2;
            } else {
                if (c != '.') break;
                n5 = n4;
            }
            if (++n4 >= n3) break;
            c = textBuilder.charAt(n4);
        }
        if (bl) {
            l = -l;
        }
        n = n5 >= 0 ? n4 - n5 - 1 : 0;
        int n6 = 0;
        if (n4 < n3 && (c == 'E' || c == 'e')) {
            int n7;
            boolean bl3;
            boolean bl4 = bl3 = (c = textBuilder.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n3) {
                c = textBuilder.charAt(n4);
            }
            while ((n7 = c - 48) >= 0 && n7 < 10) {
                int n8 = n6 * 10 + n7;
                if (n8 < n6) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                n6 = n8;
                if (++n4 >= n3) break;
                c = textBuilder.charAt(n4);
            }
            if (bl3) {
                n6 = -n6;
            }
        }
        if (cursor != null) {
            cursor.setIndex(n4);
        }
        return MathLib.toDoublePow10(l, n6 - n);
    }

    private static double parseDoubleText(Text text, TextFormat.Cursor cursor) throws NumberFormatException {
        int n;
        boolean bl;
        int n2 = cursor != null ? cursor.getIndex() : 0;
        int n3 = cursor != null ? cursor.getEndIndex() : text.length();
        int n4 = n2;
        char c = text.charAt(n4);
        if (c == 'N' && TypeFormat.match("NaN", text, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 3);
            }
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n3) {
            c = text.charAt(n4);
        }
        if (c == 'I' && TypeFormat.match("Infinity", text, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 8);
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n = c - 48) >= 0 && n < 10) {
                long l2 = l * 10L + (long)n;
                if (l2 < l) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                l = l2;
            } else {
                if (c != '.') break;
                n5 = n4;
            }
            if (++n4 >= n3) break;
            c = text.charAt(n4);
        }
        if (bl) {
            l = -l;
        }
        n = n5 >= 0 ? n4 - n5 - 1 : 0;
        int n6 = 0;
        if (n4 < n3 && (c == 'E' || c == 'e')) {
            int n7;
            boolean bl3;
            boolean bl4 = bl3 = (c = text.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n3) {
                c = text.charAt(n4);
            }
            while ((n7 = c - 48) >= 0 && n7 < 10) {
                int n8 = n6 * 10 + n7;
                if (n8 < n6) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                n6 = n8;
                if (++n4 >= n3) break;
                c = text.charAt(n4);
            }
            if (bl3) {
                n6 = -n6;
            }
        }
        if (cursor != null) {
            cursor.setIndex(n4);
        }
        return MathLib.toDoublePow10(l, n6 - n);
    }

    private static double parseDoubleString(String string, TextFormat.Cursor cursor) throws NumberFormatException {
        int n;
        boolean bl;
        int n2 = cursor != null ? cursor.getIndex() : 0;
        int n3 = cursor != null ? cursor.getEndIndex() : string.length();
        int n4 = n2;
        char c = string.charAt(n4);
        if (c == 'N' && TypeFormat.match("NaN", string, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 3);
            }
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n3) {
            c = string.charAt(n4);
        }
        if (c == 'I' && TypeFormat.match("Infinity", string, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 8);
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n = c - 48) >= 0 && n < 10) {
                long l2 = l * 10L + (long)n;
                if (l2 < l) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                l = l2;
            } else {
                if (c != '.') break;
                n5 = n4;
            }
            if (++n4 >= n3) break;
            c = string.charAt(n4);
        }
        if (bl) {
            l = -l;
        }
        n = n5 >= 0 ? n4 - n5 - 1 : 0;
        int n6 = 0;
        if (n4 < n3 && (c == 'E' || c == 'e')) {
            int n7;
            boolean bl3;
            boolean bl4 = bl3 = (c = string.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n3) {
                c = string.charAt(n4);
            }
            while ((n7 = c - 48) >= 0 && n7 < 10) {
                int n8 = n6 * 10 + n7;
                if (n8 < n6) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                n6 = n8;
                if (++n4 >= n3) break;
                c = string.charAt(n4);
            }
            if (bl3) {
                n6 = -n6;
            }
        }
        if (cursor != null) {
            cursor.setIndex(n4);
        }
        return MathLib.toDoublePow10(l, n6 - n);
    }

    private static double parseDoubleCharSequence(CharSequence charSequence, TextFormat.Cursor cursor) throws NumberFormatException {
        int n;
        boolean bl;
        int n2 = cursor != null ? cursor.getIndex() : 0;
        int n3 = cursor != null ? cursor.getEndIndex() : charSequence.length();
        int n4 = n2;
        char c = charSequence.charAt(n4);
        if (c == 'N' && TypeFormat.match("NaN", charSequence, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 3);
            }
            return Double.NaN;
        }
        boolean bl2 = bl = c == '-';
        if ((bl || c == '+') && ++n4 < n3) {
            c = charSequence.charAt(n4);
        }
        if (c == 'I' && TypeFormat.match("Infinity", charSequence, n4, n3)) {
            if (cursor != null) {
                cursor.setIndex(n4 + 8);
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        long l = 0L;
        int n5 = -1;
        while (true) {
            if ((n = c - 48) >= 0 && n < 10) {
                long l2 = l * 10L + (long)n;
                if (l2 < l) {
                    throw new NumberFormatException("Too many digits - Overflow");
                }
                l = l2;
            } else {
                if (c != '.') break;
                n5 = n4;
            }
            if (++n4 >= n3) break;
            c = charSequence.charAt(n4);
        }
        if (bl) {
            l = -l;
        }
        n = n5 >= 0 ? n4 - n5 - 1 : 0;
        int n6 = 0;
        if (n4 < n3 && (c == 'E' || c == 'e')) {
            int n7;
            boolean bl3;
            boolean bl4 = bl3 = (c = charSequence.charAt(++n4)) == '-';
            if ((bl3 || c == '+') && ++n4 < n3) {
                c = charSequence.charAt(n4);
            }
            while ((n7 = c - 48) >= 0 && n7 < 10) {
                int n8 = n6 * 10 + n7;
                if (n8 < n6) {
                    throw new NumberFormatException("Exponent Overflow");
                }
                n6 = n8;
                if (++n4 >= n3) break;
                c = charSequence.charAt(n4);
            }
            if (bl3) {
                n6 = -n6;
            }
        }
        if (cursor != null) {
            cursor.setIndex(n4);
        }
        return MathLib.toDoublePow10(l, n6 - n);
    }

    static boolean match(String string, CharSequence charSequence, int n, int n2) {
        for (int i = 0; i < string.length(); ++i) {
            if (n + i < n2 && charSequence.charAt(n + i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean match(String string, String string2, int n, int n2) {
        for (int i = 0; i < string.length(); ++i) {
            if (n + i < n2 && string2.charAt(n + i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Appendable format(boolean bl, Appendable appendable) throws IOException {
        return bl ? appendable.append('t').append('r').append('u').append('e') : appendable.append('f').append('a').append('l').append('s').append('e');
    }

    public static Appendable format(int n, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(n);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(int n, int n2, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(n, n2);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(n, n2);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(long l, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(l);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(long l, int n, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(l);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(l, n);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(float f, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(f);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(f);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(double d, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(d);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(d);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    public static Appendable format(double d, int n, boolean bl, boolean bl2, Appendable appendable) throws IOException {
        if (appendable instanceof TextBuilder) {
            return ((TextBuilder)appendable).append(d, n, bl, bl2);
        }
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append(d, n, bl, bl2);
        TypeFormat.appendTo(appendable, textBuilder);
        TextBuilder.recycle(textBuilder);
        return appendable;
    }

    private static void appendTo(Object object, TextBuilder textBuilder) throws IOException {
        if (object instanceof StringBuffer) {
            textBuilder.appendTo((StringBuffer)object);
        } else if (object instanceof StringBuilder) {
            textBuilder.appendTo((StringBuilder)object);
        } else {
            ((Appendable)object).append(textBuilder);
        }
    }
}

