/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import javolution.context.RealtimeObject;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastSet<E>
extends FastCollection<E>
implements Set<E>,
Reusable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastSet();
        }

        public void cleanup(Object object) {
            ((FastSet)object).reset();
        }
    };
    private transient FastMap _map;
    private static final long serialVersionUID = 3257563997099275574L;

    public FastSet() {
        this(new FastMap());
    }

    public FastSet(String string) {
        this(new FastMap(string));
    }

    public FastSet(int n) {
        this(new FastMap(n));
    }

    public FastSet(Set<? extends E> set) {
        this(new FastMap(set.size()));
        this.addAll(set);
    }

    private FastSet(FastMap fastMap) {
        this._map = fastMap;
    }

    public static <E> FastSet<E> newInstance() {
        return (FastSet)FACTORY.object();
    }

    public static void recycle(FastSet fastSet) {
        FACTORY.recycle(fastSet);
    }

    @Override
    public final int size() {
        return this._map.size();
    }

    @Override
    public final boolean add(E e) {
        return this._map.put(e, e) == null;
    }

    @Override
    public Set<E> unmodifiable() {
        return (Set)super.unmodifiable();
    }

    @Override
    public final void clear() {
        this._map.clear();
    }

    @Override
    public final boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    @Override
    public final boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    @Override
    public FastCollection<E> setValueComparator(FastComparator fastComparator) {
        super.setValueComparator(fastComparator);
        this._map.setKeyComparator(fastComparator);
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this._map.reset();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this._map = new FastMap(n);
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        int n2 = n;
        while (n2-- != 0) {
            Object object = objectInputStream.readObject();
            this._map.put(object, object);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.size());
        objectOutputStream.writeObject(this.getValueComparator());
        FastCollection.Record record = this._map.head();
        FastMap.Entry entry = this._map.tail();
        while ((record = ((FastMap.Entry)record).getNext()) != entry) {
            objectOutputStream.writeObject(((FastMap.Entry)record).getKey());
        }
    }

    @Override
    public final FastCollection.Record head() {
        return this._map.head();
    }

    @Override
    public final FastCollection.Record tail() {
        return this._map.tail();
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((FastMap.Entry)record).getKey();
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this._map.remove(((FastMap.Entry)record).getKey());
    }
}

