/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurableEmbedder
implements Embeddable {
    private Embedder embedder = new Embedder();
    private Configuration configuration = new MostUsefulConfiguration();
    private List<CandidateSteps> candidateSteps = new ArrayList<CandidateSteps>();
    private InjectableStepsFactory stepsFactory;

    @Override
    public void useEmbedder(Embedder embedder) {
        this.embedder = embedder;
    }

    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public void addSteps(CandidateSteps ... steps) {
        this.addSteps(Arrays.asList(steps));
    }

    public void addSteps(List<CandidateSteps> steps) {
        this.candidateSteps.addAll(steps);
    }

    public List<CandidateSteps> candidateSteps() {
        return this.candidateSteps;
    }

    public void useStepsFactory(InjectableStepsFactory stepsFactory) {
        this.stepsFactory = stepsFactory;
    }

    public InjectableStepsFactory stepsFactory() {
        return this.stepsFactory;
    }

    public Embedder configuredEmbedder() {
        this.embedder.useConfiguration(this.configuration());
        this.embedder.useCandidateSteps(this.candidateSteps());
        this.embedder.useStepsFactory(this.stepsFactory());
        return this.embedder;
    }
}

