/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GivenStories {
    public static final GivenStories EMPTY = new GivenStories("");
    private final List<GivenStory> givenStories = new ArrayList<GivenStory>();
    private final String givenStoriesAsString;
    private ExamplesTable examplesTable = ExamplesTable.EMPTY;

    public GivenStories(String givenStoriesAsString) {
        this.givenStoriesAsString = givenStoriesAsString;
        if (!StringUtils.isBlank((String)givenStoriesAsString)) {
            this.parse();
        }
    }

    private void parse() {
        this.givenStories.clear();
        for (String storyPath : this.givenStoriesAsString.split(",", -1)) {
            this.givenStories.add(new GivenStory(storyPath));
        }
    }

    public List<GivenStory> getStories() {
        for (GivenStory givenStory : this.givenStories) {
            givenStory.useParameters(this.parametersByAnchor(givenStory.getAnchor()));
        }
        return this.givenStories;
    }

    private Map<String, String> parametersByAnchor(String anchor) {
        int examplesRow = -1;
        if (!StringUtils.isBlank((String)anchor)) {
            try {
                examplesRow = Integer.parseInt(anchor);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Map<String, String> parameters = null;
        if (examplesRow > -1 && examplesRow < this.examplesTable.getRowCount()) {
            parameters = this.examplesTable.getRow(examplesRow);
        }
        if (parameters == null) {
            return new HashMap<String, String>();
        }
        return parameters;
    }

    public List<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (GivenStory story : this.givenStories) {
            paths.add(story.asString().trim());
        }
        return Collections.unmodifiableList(paths);
    }

    public boolean requireParameters() {
        for (GivenStory givenStory : this.givenStories) {
            if (!givenStory.hasAnchor()) continue;
            return true;
        }
        return false;
    }

    public void useExamplesTable(ExamplesTable examplesTable) {
        this.examplesTable = examplesTable;
    }

    public String asString() {
        return this.givenStoriesAsString;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

