/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Story {
    private final String path;
    private final Description description;
    private final Narrative narrative;
    private final Meta meta;
    private final List<Scenario> scenarios;
    private String name;
    private final GivenStories givenStories;

    public Story() {
        this(Arrays.asList(new Scenario[0]));
    }

    public Story(String path) {
        this(path, Description.EMPTY, Narrative.EMPTY, Arrays.asList(new Scenario[0]));
    }

    public Story(List<Scenario> scenarios) {
        this(Description.EMPTY, Narrative.EMPTY, scenarios);
    }

    public Story(Description description, Narrative narrative, List<Scenario> scenarios) {
        this(null, description, narrative, scenarios);
    }

    public Story(String path, Description description, Narrative narrative, List<Scenario> scenarios) {
        this(path, description, Meta.EMPTY, narrative, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, List<Scenario> scenarios) {
        this(path, description, meta, narrative, GivenStories.EMPTY, scenarios);
    }

    public Story(String path, Description description, Meta meta, Narrative narrative, GivenStories givenStories, List<Scenario> scenarios) {
        this.path = path != null ? path : "";
        this.description = description;
        this.narrative = narrative;
        this.meta = meta;
        this.givenStories = givenStories;
        this.scenarios = scenarios;
    }

    public String getPath() {
        return this.path;
    }

    public Description getDescription() {
        return this.description;
    }

    public Narrative getNarrative() {
        return this.narrative;
    }

    public Meta asMeta(String prefix) {
        Properties p = new Properties();
        p.setProperty(prefix + "path", this.path);
        p.setProperty(prefix + "description", this.description.asString());
        p.setProperty(prefix + "narrative", this.narrative.toString());
        return new Meta(p);
    }

    public Meta getMeta() {
        return this.meta;
    }

    public GivenStories getGivenStories() {
        return this.givenStories;
    }

    public List<Scenario> getScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public String getName() {
        return this.name != null ? this.name : this.path;
    }

    public void namedAs(String name) {
        this.name = name;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

