/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.model.TableUtils;

public class TableTransformers {
    public static final String FROM_LANDSCAPE = "FROM_LANDSCAPE";
    private final Map<String, TableTransformer> transformers = new HashMap<String, TableTransformer>();

    public TableTransformers() {
        this.useTransformer(FROM_LANDSCAPE, new FromLandscape());
    }

    public String transform(String transformerName, String tableAsString, Properties properties) {
        TableTransformer transformer = this.transformers.get(transformerName);
        if (transformer != null) {
            return transformer.transform(tableAsString, properties);
        }
        return tableAsString;
    }

    public void useTransformer(String name, TableTransformer transformer) {
        this.transformers.put(name, transformer);
    }

    public static class FromLandscape
    implements TableTransformer {
        private static final String ROW_SEPARATOR = "\n";

        public String transform(String tableAsString, Properties properties) {
            boolean trim = Boolean.parseBoolean(properties.getProperty("trim", "true"));
            String ignorableSeparator = properties.getProperty("ignorableSeparator", "|--");
            String headerSeparator = properties.getProperty("headerSeparator", "|");
            String valueSeparator = properties.getProperty("valueSeparator", "|");
            LinkedHashMap<String, ArrayList<String>> data = new LinkedHashMap<String, ArrayList<String>>();
            String[] rowsAsString = tableAsString.split(ROW_SEPARATOR);
            for (int row = 0; row < rowsAsString.length; ++row) {
                String rowAsString = rowsAsString[row];
                if (rowAsString.startsWith(ignorableSeparator) || rowAsString.length() == 0) continue;
                List<String> values = TableUtils.parseRow(rowAsString, valueSeparator, trim);
                String header = values.get(0);
                ArrayList<String> rowValues = new ArrayList<String>(values);
                rowValues.remove(0);
                data.put(header, rowValues);
            }
            StringBuffer sb = new StringBuffer();
            int numberOfRows = 1;
            sb.append(headerSeparator);
            for (String header : data.keySet()) {
                sb.append(header).append(headerSeparator);
                numberOfRows = ((List)data.get(header)).size();
            }
            sb.append(ROW_SEPARATOR);
            for (int r = 0; r < numberOfRows; ++r) {
                sb.append(valueSeparator);
                for (List rows : data.values()) {
                    sb.append((String)rows.get(r)).append(valueSeparator);
                }
                sb.append(ROW_SEPARATOR);
            }
            return sb.toString();
        }
    }

    public static interface TableTransformer {
        public String transform(String var1, Properties var2);
    }
}

