/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class EmbedderControls {
    private boolean batch = false;
    private boolean skip = false;
    private boolean generateViewAfterStories = true;
    private boolean ignoreFailureInStories = false;
    private boolean ignoreFailureInView = false;
    private boolean verboseFailures = false;
    private boolean verboseFiltering = false;
    private String storyTimeouts = "300";
    private int threads = 1;
    private boolean failOnStoryTimeout = false;

    public boolean batch() {
        return this.batch;
    }

    public boolean skip() {
        return this.skip;
    }

    public boolean generateViewAfterStories() {
        return this.generateViewAfterStories;
    }

    public boolean ignoreFailureInStories() {
        return this.ignoreFailureInStories;
    }

    public boolean ignoreFailureInView() {
        return this.ignoreFailureInView;
    }

    public boolean verboseFailures() {
        return this.verboseFailures;
    }

    public boolean verboseFiltering() {
        return this.verboseFiltering;
    }

    public String storyTimeouts() {
        return this.storyTimeouts;
    }

    public long storyTimeoutInSecs() {
        try {
            return Long.parseLong(this.storyTimeouts);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String storyTimeoutInSecsByPath() {
        return this.storyTimeouts();
    }

    public boolean failOnStoryTimeout() {
        return this.failOnStoryTimeout;
    }

    public int threads() {
        return this.threads;
    }

    public EmbedderControls doBatch(boolean batch) {
        this.batch = batch;
        return this;
    }

    public EmbedderControls doSkip(boolean skip) {
        this.skip = skip;
        return this;
    }

    public EmbedderControls doGenerateViewAfterStories(boolean generateViewAfterStories) {
        this.generateViewAfterStories = generateViewAfterStories;
        return this;
    }

    public EmbedderControls doIgnoreFailureInStories(boolean ignoreFailureInStories) {
        this.ignoreFailureInStories = ignoreFailureInStories;
        return this;
    }

    public EmbedderControls doIgnoreFailureInView(boolean ignoreFailureInView) {
        this.ignoreFailureInView = ignoreFailureInView;
        return this;
    }

    public EmbedderControls doVerboseFailures(boolean verboseFailures) {
        this.verboseFailures = verboseFailures;
        return this;
    }

    public EmbedderControls doVerboseFiltering(boolean verboseFiltering) {
        this.verboseFiltering = verboseFiltering;
        return this;
    }

    public EmbedderControls useStoryTimeouts(String storyTimeouts) {
        this.storyTimeouts = storyTimeouts;
        return this;
    }

    public EmbedderControls useStoryTimeoutInSecs(long storyTimeoutInSecs) {
        this.useStoryTimeouts(Long.toString(storyTimeoutInSecs));
        return this;
    }

    public EmbedderControls useStoryTimeoutInSecsByPath(String storyTimeoutInSecsByPath) {
        this.useStoryTimeouts(storyTimeoutInSecsByPath);
        return this;
    }

    public EmbedderControls doFailOnStoryTimeout(boolean failOnStoryTimeout) {
        this.failOnStoryTimeout = failOnStoryTimeout;
        return this;
    }

    public EmbedderControls useThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

