/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.model.Meta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lifecycle {
    public static final Lifecycle EMPTY = new Lifecycle();
    private Steps before;
    private Steps[] after;

    public Lifecycle() {
        this(Steps.EMPTY, new Steps[0]);
    }

    public Lifecycle(Steps before, Steps ... after) {
        this.before = before;
        this.after = after;
    }

    public List<String> getBeforeSteps() {
        return this.before.steps;
    }

    public List<String> getAfterSteps() {
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            afterSteps.addAll(steps.steps);
        }
        return afterSteps;
    }

    public Set<AfterScenario.Outcome> getOutcomes() {
        LinkedHashSet<AfterScenario.Outcome> outcomes = new LinkedHashSet<AfterScenario.Outcome>();
        for (Steps steps : this.after) {
            outcomes.add(steps.outcome);
        }
        return outcomes;
    }

    public MetaFilter getMetaFilter(AfterScenario.Outcome outcome) {
        for (Steps steps : this.after) {
            if (!outcome.equals((Object)steps.outcome) || !StringUtils.isNotBlank((String)steps.metaFilter)) continue;
            return new MetaFilter(steps.metaFilter);
        }
        return MetaFilter.EMPTY;
    }

    public List<String> getAfterSteps(AfterScenario.Outcome outcome) {
        return this.getAfterSteps(outcome, Meta.EMPTY);
    }

    public List<String> getAfterSteps(AfterScenario.Outcome outcome, Meta meta) {
        MetaFilter filter = this.getMetaFilter(outcome);
        ArrayList<String> afterSteps = new ArrayList<String>();
        for (Steps steps : this.after) {
            if (!outcome.equals((Object)steps.outcome)) continue;
            if (meta.equals(Meta.EMPTY)) {
                afterSteps.addAll(steps.steps);
                continue;
            }
            if (!filter.allow(meta)) continue;
            afterSteps.addAll(steps.steps);
        }
        return afterSteps;
    }

    public boolean isEmpty() {
        return EMPTY == this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Steps {
        public static Steps EMPTY = new Steps(Arrays.asList(new String[0]));
        private AfterScenario.Outcome outcome;
        private String metaFilter;
        private List<String> steps;

        public Steps(List<String> steps) {
            this(null, steps);
        }

        public Steps(AfterScenario.Outcome outcome, List<String> steps) {
            this(outcome, null, steps);
        }

        public Steps(AfterScenario.Outcome outcome, String metaFilter, List<String> steps) {
            this.outcome = outcome;
            this.metaFilter = metaFilter;
            this.steps = steps;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

