/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.reporters.ConsoleOutput;

public class ANSIConsoleOutput
extends ConsoleOutput {
    private static final char ESCAPE_CHARACTER = '\u001b';
    private static final String SGR_CONTROL = "m";
    private static final String CODE_SEPARATOR = ";";
    private Map<String, SGRCode> codes = new HashMap<String, SGRCode>(){
        {
            this.put("successful", SGRCode.GREEN);
            this.put("pending", SGRCode.YELLOW);
            this.put("pendingMethod", SGRCode.YELLOW);
            this.put("notPerformed", SGRCode.MAGENTA);
            this.put("ignorable", SGRCode.BLUE);
            this.put("failed", SGRCode.RED);
            this.put("cancelled", SGRCode.RED);
            this.put("restarted", SGRCode.MAGENTA);
        }
    };

    public ANSIConsoleOutput() {
    }

    public ANSIConsoleOutput(Keywords keywords) {
        super(keywords);
    }

    public ANSIConsoleOutput(Properties outputPatterns, Keywords keywords, boolean reportFailureTrace) {
        super(outputPatterns, keywords, reportFailureTrace);
    }

    protected String format(String eventKey, String defaultPattern, Object ... args) {
        String formatted = super.format(eventKey, defaultPattern, args);
        if (this.codes.containsKey(eventKey)) {
            SGRCode code = this.codes.get(eventKey);
            return this.escapeCodeFor(code) + this.boldifyParams(formatted, code) + this.escapeCodeFor(SGRCode.RESET);
        }
        return formatted;
    }

    private String boldifyParams(String formatted, SGRCode currentColor) {
        String valueStart = this.lookupPattern("\uff5f", "\uff5f");
        String valueEnd = this.lookupPattern("\uff60", "\uff60");
        return formatted.replaceAll(valueStart, this.escapeCodeFor(SGRCode.BOLD, currentColor)).replaceAll(valueEnd, this.escapeCodeFor(SGRCode.RESET, currentColor));
    }

    private String escapeCodeFor(SGRCode code) {
        return this.controlSequenceInitiator((Object)((Object)code) + SGR_CONTROL);
    }

    private String escapeCodeFor(SGRCode first, SGRCode second) {
        return this.controlSequenceInitiator((Object)((Object)first) + CODE_SEPARATOR + (Object)((Object)second) + SGR_CONTROL);
    }

    private String controlSequenceInitiator(String code) {
        return "\u001b[" + code;
    }

    public void assignCodeToEvent(String eventKey, SGRCode code) {
        this.codes.put(eventKey, code);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SGRCode {
        RESET(0),
        BOLD(1),
        DARK(2),
        ITALIC(3),
        UNDERLINE(4),
        BLINK(5),
        RAPID_BLINK(6),
        NEGATIVE(7),
        CONCEALED(8),
        STRIKETHROUGH(9),
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        WHITE(37),
        ON_BLACK(40),
        ON_RED(41),
        ON_GREEN(42),
        ON_YELLOW(43),
        ON_BLUE(44),
        ON_MAGENTA(45),
        ON_CYAN(46),
        ON_WHITE(47);

        private final int code;

        private SGRCode(int code) {
            this.code = code;
        }

        public String toString() {
            return Integer.toString(this.code);
        }
    }
}

