/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import com.thoughtworks.paranamer.NullParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.IgnoringStepsFailure;
import org.jbehave.core.failures.RestartingScenarioFailure;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.Meta;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.jbehave.core.steps.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCreator {
    public static final String PARAMETER_TABLE_START = "\uff3b";
    public static final String PARAMETER_TABLE_END = "\uff3d";
    public static final String PARAMETER_VALUE_START = "\uff5f";
    public static final String PARAMETER_VALUE_END = "\uff60";
    public static final String PARAMETER_VALUE_NEWLINE = "\u2424";
    public static final UUIDExceptionWrapper NO_FAILURE = new UUIDExceptionWrapper("no failure");
    private static final String NEWLINE = "\n";
    private static final String SPACE = " ";
    private static final String NONE = "";
    private final Class<?> stepsType;
    private final InjectableStepsFactory stepsFactory;
    private final ParameterConverters parameterConverters;
    private final ParameterControls parameterControls;
    private final Pattern delimitedNamePattern;
    private final StepMatcher stepMatcher;
    private StepMonitor stepMonitor;
    private Paranamer paranamer = new NullParanamer();
    private boolean dryRun = false;

    public StepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, ParameterConverters parameterConverters, ParameterControls parameterControls, StepMatcher stepMatcher, StepMonitor stepMonitor) {
        this.stepsType = stepsType;
        this.stepsFactory = stepsFactory;
        this.parameterConverters = parameterConverters;
        this.parameterControls = parameterControls;
        this.stepMatcher = stepMatcher;
        this.stepMonitor = stepMonitor;
        this.delimitedNamePattern = Pattern.compile(parameterControls.nameDelimiterLeft() + "(\\w+?)" + parameterControls.nameDelimiterRight());
    }

    public void useStepMonitor(StepMonitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public void useParanamer(Paranamer paranamer) {
        this.paranamer = paranamer;
    }

    public void doDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Object stepsInstance() {
        return this.stepsFactory.createInstanceOfType(this.stepsType);
    }

    public Step createBeforeOrAfterStep(Method method, Meta meta) {
        return new BeforeOrAfterStep(method, meta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta) {
        switch (outcome) {
            default: {
                return new BeforeOrAfterStep(method, storyAndScenarioMeta);
            }
            case SUCCESS: {
                return new UponSuccessStep(method, storyAndScenarioMeta);
            }
            case FAILURE: 
        }
        return new UponFailureStep(method, storyAndScenarioMeta);
    }

    public Map<String, String> matchedParameters(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        HashMap<String, String> matchedParameters = new HashMap<String, String>();
        if (this.stepMatcher.find(stepWithoutStartingWord)) {
            ParameterName[] parameterNames = this.parameterNames(method);
            Type[] types = method.getGenericParameterTypes();
            String[] values = this.parameterValuesForStep(namedParameters, types, parameterNames);
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i].name;
                if (name == null) {
                    name = this.stepMatcher.parameterNames()[i];
                }
                matchedParameters.put(name, values[i]);
            }
        }
        return matchedParameters;
    }

    private ParameterName[] parameterNames(Method method) {
        String[] annotatedNames = this.annotatedParameterNames(method);
        String[] paranamerNames = this.paranamerParameterNames(method);
        ParameterName[] parameterNames = new ParameterName[annotatedNames.length];
        for (int i = 0; i < annotatedNames.length; ++i) {
            parameterNames[i] = this.parameterName(annotatedNames, paranamerNames, i);
        }
        return parameterNames;
    }

    private ParameterName parameterName(String[] annotatedNames, String[] paranamerNames, int i) {
        String name = annotatedNames[i];
        boolean annotated = true;
        if (name == null) {
            name = paranamerNames.length > i ? paranamerNames[i] : null;
            annotated = false;
        }
        return new ParameterName(name, annotated);
    }

    private String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.annotationName(annotation);
            }
        }
        return names;
    }

    private String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    private String[] paranamerParameterNames(Method method) {
        return this.paranamer.lookupParameterNames((AccessibleObject)method, false);
    }

    public Step createParametrisedStep(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters) {
        return new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
    }

    public Step createParametrisedStepUponOutcome(Method method, String stepAsString, String stepWithoutStartingWord, Map<String, String> namedParameters, AfterScenario.Outcome outcome) {
        switch (outcome) {
            case ANY: {
                return new UponAnyParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
            }
            case SUCCESS: {
                return new UponSuccessParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
            }
            case FAILURE: {
                return new UponFailureParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
            }
        }
        return new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
    }

    private String parametrisedStep(String stepAsString, Map<String, String> namedParameters, Type[] types, ParameterName[] names, String[] parameterValues) {
        String parametrisedStep = stepAsString;
        boolean hasTable = this.hasTable(types);
        for (int position = 0; position < types.length; ++position) {
            parametrisedStep = this.markParsedParameterValue(parametrisedStep, types[position], parameterValues[position], hasTable);
        }
        for (String name : namedParameters.keySet()) {
            parametrisedStep = this.markNamedParameterValue(parametrisedStep, namedParameters, name);
        }
        return parametrisedStep;
    }

    private boolean hasTable(Type[] types) {
        for (Type type : types) {
            if (!this.isTable(type)) continue;
            return true;
        }
        return false;
    }

    private String markNamedParameterValue(String stepText, Map<String, String> namedParameters, String name) {
        String value = this.namedParameter(namedParameters, name);
        if (value != null) {
            stepText = stepText.replace(this.delimitedName(name), this.markedValue(value));
        }
        return stepText;
    }

    private String delimitedName(String name) {
        return this.parameterControls.nameDelimiterLeft() + name + this.parameterControls.nameDelimiterRight();
    }

    private String markParsedParameterValue(String stepText, Type type, String value, boolean hasTable) {
        if (value != null) {
            if (this.isTable(type)) {
                stepText = stepText.replace(value, this.markedTable(value));
            } else {
                if (value.trim().length() != 0) {
                    String markedValue = this.markedValue(value);
                    String leftPad = SPACE;
                    String rightPad = stepText.endsWith(value) ? NONE : SPACE;
                    stepText = stepText.replace(this.pad(value, leftPad, rightPad), this.pad(markedValue, leftPad, rightPad));
                }
                if (!hasTable) {
                    stepText = stepText.replace(NEWLINE, PARAMETER_VALUE_NEWLINE);
                }
            }
        }
        return stepText;
    }

    private String markedTable(String value) {
        return this.pad(value, PARAMETER_TABLE_START, PARAMETER_TABLE_END);
    }

    private String markedValue(String value) {
        return this.pad(value, PARAMETER_VALUE_START, PARAMETER_VALUE_END);
    }

    private String pad(String value, String left, String right) {
        return left + value + right;
    }

    private boolean isTable(Type type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(ExamplesTable.class);
    }

    private String[] parameterValuesForStep(Map<String, String> namedParameters, Type[] types, ParameterName[] names) {
        String[] parameters = new String[types.length];
        for (int position = 0; position < types.length; ++position) {
            parameters[position] = this.parameterForPosition(position, names, namedParameters);
        }
        return parameters;
    }

    private Object[] convertParameterValues(String[] valuesAsString, Type[] types) {
        Object[] parameters = new Object[valuesAsString.length];
        for (int position = 0; position < valuesAsString.length; ++position) {
            parameters[position] = this.parameterConverters.convert(valuesAsString[position], types[position]);
        }
        return parameters;
    }

    private String parameterForPosition(int position, ParameterName[] names, Map<String, String> namedParameters) {
        int namePosition = this.parameterPosition(names, position);
        String parameter = null;
        if (namePosition != -1) {
            String name = names[position].name;
            boolean annotated = names[position].annotated;
            boolean delimitedNamedParameters = false;
            if (this.isGroupName(name)) {
                parameter = this.matchedParameter(name);
                String delimitedName = this.delimitedNameFor(parameter);
                if (delimitedName != null) {
                    name = delimitedName;
                    delimitedNamedParameters = true;
                } else {
                    this.monitorUsingNameForParameter(name, position, annotated);
                }
            }
            if (delimitedNamedParameters || this.isTableName(namedParameters, name)) {
                this.monitorUsingTableNameForParameter(name, position, annotated);
                parameter = this.namedParameter(namedParameters, name);
            }
        }
        if (parameter == null) {
            this.stepMonitor.usingNaturalOrderForParameter(position);
            parameter = this.matchedParameter(position);
            String delimitedName = this.delimitedNameFor(parameter);
            if (delimitedName != null && this.isTableName(namedParameters, delimitedName)) {
                parameter = this.namedParameter(namedParameters, delimitedName);
            }
        }
        this.stepMonitor.foundParameter(parameter, position);
        return parameter;
    }

    private void monitorUsingTableNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingTableAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingTableParameterNameForParameter(name, position);
        }
    }

    private void monitorUsingNameForParameter(String name, int position, boolean usingAnnotationNames) {
        if (usingAnnotationNames) {
            this.stepMonitor.usingAnnotatedNameForParameter(name, position);
        } else {
            this.stepMonitor.usingParameterNameForParameter(name, position);
        }
    }

    private String delimitedNameFor(String parameter) {
        if (!this.parameterControls.delimiterNamedParameters()) {
            return null;
        }
        Matcher matcher = this.delimitedNamePattern.matcher(parameter);
        return matcher.matches() ? matcher.group(1) : null;
    }

    String matchedParameter(String name) {
        String[] parameterNames = this.stepMatcher.parameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            if (!name.equals(parameterName)) continue;
            return this.matchedParameter(i);
        }
        throw new ParameterNotFound(name, parameterNames);
    }

    private String matchedParameter(int position) {
        int matchedPosition = position + 1;
        String[] parameterNames = this.stepMatcher.parameterNames();
        if (matchedPosition <= parameterNames.length) {
            return this.stepMatcher.parameter(matchedPosition);
        }
        throw new ParameterNotFound(position, parameterNames);
    }

    private int parameterPosition(ParameterName[] names, int position) {
        if (names.length == 0) {
            return -1;
        }
        String positionName = names[position].name;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].name;
            if (name == null || !positionName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGroupName(String name) {
        String[] groupNames;
        for (String groupName : groupNames = this.stepMatcher.parameterNames()) {
            if (!name.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private String namedParameter(Map<String, String> namedParameters, String name) {
        return namedParameters.get(name);
    }

    private boolean isTableName(Map<String, String> namedParameters, String name) {
        return this.namedParameter(namedParameters, name) != null;
    }

    public static Step createPendingStep(String stepAsString, String previousNonAndStep) {
        return new PendingStep(stepAsString, previousNonAndStep);
    }

    public static Step createIgnorableStep(String stepAsString) {
        return new IgnorableStep(stepAsString);
    }

    private static class ParameterName {
        private String name;
        private boolean annotated;

        private ParameterName(String name, boolean annotated) {
            this.name = name;
            this.annotated = annotated;
        }
    }

    private class MethodInvoker {
        private final Method method;
        private final ParameterConverters parameterConverters;
        private final Paranamer paranamer;
        private final Meta meta;
        private final Type[] parameterTypes;

        public MethodInvoker(Method method, ParameterConverters parameterConverters, Paranamer paranamer, Meta meta) {
            this.method = method;
            this.parameterConverters = parameterConverters;
            this.paranamer = paranamer;
            this.meta = meta;
            this.parameterTypes = method.getGenericParameterTypes();
        }

        public void invoke() throws InvocationTargetException, IllegalAccessException {
            this.method.invoke(StepCreator.this.stepsInstance(), this.parameterValuesFrom(this.meta));
        }

        private Parameter[] methodParameters() {
            Parameter[] parameters = new Parameter[this.parameterTypes.length];
            String[] annotatedNames = StepCreator.this.annotatedParameterNames(this.method);
            String[] paranamerNames = this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            for (int position = 0; position < this.parameterTypes.length; ++position) {
                String name = this.parameterNameFor(position, annotatedNames, paranamerNames);
                parameters[position] = new Parameter(position, this.parameterTypes[position], name);
            }
            return parameters;
        }

        private String parameterNameFor(int position, String[] annotatedNames, String[] paranamerNames) {
            String annotatedName = this.nameByPosition(annotatedNames, position);
            String paranamerName = this.nameByPosition(paranamerNames, position);
            if (annotatedName != null) {
                return annotatedName;
            }
            if (paranamerName != null) {
                return paranamerName;
            }
            return null;
        }

        private String nameByPosition(String[] names, int position) {
            return position < names.length ? names[position] : null;
        }

        private Object[] parameterValuesFrom(Meta meta) {
            Object[] values = new Object[this.parameterTypes.length];
            for (Parameter parameter : this.methodParameters()) {
                values[((Parameter)parameter).position] = this.parameterConverters.convert(parameter.valueFrom(meta), parameter.type);
            }
            return values;
        }

        private class Parameter {
            private final int position;
            private final Type type;
            private final String name;

            public Parameter(int position, Type type, String name) {
                this.position = position;
                this.type = type;
                this.name = name;
            }

            public String valueFrom(Meta meta) {
                if (this.name == null) {
                    return null;
                }
                return meta.getProperty(this.name);
            }
        }
    }

    public static class IgnorableStep
    extends AbstractStep {
        private final String stepAsString;

        public IgnorableStep(String stepAsString) {
            this.stepAsString = stepAsString;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.ignorable(this.stepAsString);
        }

        public String asString(Keywords keywords) {
            return this.stepAsString;
        }
    }

    public static class PendingStep
    extends AbstractStep {
        private final String stepAsString;
        private final String previousNonAndStep;
        private Method method;

        public PendingStep(String stepAsString, String previousNonAndStep) {
            this.stepAsString = stepAsString;
            this.previousNonAndStep = previousNonAndStep;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.pending(this.stepAsString);
        }

        public String stepAsString() {
            return this.stepAsString;
        }

        public String previousNonAndStepAsString() {
            return this.previousNonAndStep;
        }

        public void annotatedOn(Method method) {
            this.method = method;
        }

        public boolean annotated() {
            return this.method != null;
        }

        public String asString(Keywords keywords) {
            return this.stepAsString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UponFailureParametrisedStep
    extends AbstractStep {
        private ParametrisedStep parametrisedStep;

        public UponFailureParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.parametrisedStep = new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.parametrisedStep.perform(storyFailureIfItHappened);
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        @Override
        public String asString(Keywords keywords) {
            return this.parametrisedStep.asString(keywords);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UponSuccessParametrisedStep
    extends AbstractStep {
        private ParametrisedStep parametrisedStep;

        public UponSuccessParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.parametrisedStep = new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.parametrisedStep.perform(storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.parametrisedStep.asString(keywords);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UponAnyParametrisedStep
    extends AbstractStep {
        private ParametrisedStep parametrisedStep;

        public UponAnyParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.parametrisedStep = new ParametrisedStep(stepAsString, method, stepWithoutStartingWord, namedParameters);
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.parametrisedStep.perform(storyFailureIfItHappened);
        }

        @Override
        public String asString(Keywords keywords) {
            return this.parametrisedStep.asString(keywords);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParametrisedStep
    extends AbstractStep {
        private Object[] convertedParameters;
        private String parametrisedStep;
        private final String stepAsString;
        private final Method method;
        private final String stepWithoutStartingWord;
        private final Map<String, String> namedParameters;

        public ParametrisedStep(String stepAsString, Method method, String stepWithoutStartingWord, Map<String, String> namedParameters) {
            this.stepAsString = stepAsString;
            this.method = method;
            this.stepWithoutStartingWord = stepWithoutStartingWord;
            this.namedParameters = namedParameters;
        }

        public void describeTo(StoryReporter storyReporter) {
            storyReporter.beforeStep(this.stepAsString);
        }

        @Override
        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            Timer timer = new Timer().start();
            try {
                this.parametriseStep();
                StepCreator.this.stepMonitor.performing(this.parametrisedStep, StepCreator.this.dryRun);
                if (!StepCreator.this.dryRun) {
                    this.method.invoke(StepCreator.this.stepsInstance(), this.convertedParameters);
                }
                return AbstractStepResult.successful(this.stepAsString).withParameterValues(this.parametrisedStep).withDurationInMillis(timer.stop());
            }
            catch (ParameterNotFound e) {
                return AbstractStepResult.pending(this.stepAsString).withParameterValues(this.parametrisedStep);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RestartingScenarioFailure) {
                    throw (RestartingScenarioFailure)e.getCause();
                }
                if (e.getCause() instanceof IgnoringStepsFailure) {
                    throw (IgnoringStepsFailure)e.getCause();
                }
                Throwable failureCause = e.getCause();
                if (failureCause instanceof UUIDExceptionWrapper) {
                    failureCause = failureCause.getCause();
                }
                return AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, failureCause)).withParameterValues(this.parametrisedStep).withDurationInMillis(timer.stop());
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.stepAsString, new UUIDExceptionWrapper(this.stepAsString, t)).withParameterValues(this.parametrisedStep).withDurationInMillis(timer.stop());
            }
        }

        @Override
        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            try {
                this.parametriseStep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return AbstractStepResult.notPerformed(this.stepAsString).withParameterValues(this.parametrisedStep);
        }

        @Override
        public String asString(Keywords keywords) {
            if (this.parametrisedStep == null) {
                this.parametriseStep();
            }
            return this.parametrisedStep;
        }

        private void parametriseStep() {
            StepCreator.this.stepMatcher.find(this.stepWithoutStartingWord);
            ParameterName[] names = StepCreator.this.parameterNames(this.method);
            Type[] types = this.method.getGenericParameterTypes();
            String[] parameterValues = StepCreator.this.parameterValuesForStep(this.namedParameters, types, names);
            this.convertedParameters = StepCreator.this.convertParameterValues(parameterValues, types);
            this.addNamedParametersToExamplesTables();
            this.parametrisedStep = StepCreator.this.parametrisedStep(this.stepAsString, this.namedParameters, types, names, parameterValues);
        }

        private void addNamedParametersToExamplesTables() {
            for (Object object : this.convertedParameters) {
                if (!(object instanceof ExamplesTable)) continue;
                ((ExamplesTable)object).withNamedParameters(this.namedParameters);
            }
        }
    }

    public class UponFailureStep
    extends AbstractStep {
        private final BeforeOrAfterStep beforeOrAfterStep;

        public UponFailureStep(Method method, Meta storyAndScenarioMeta) {
            this.beforeOrAfterStep = new BeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        public String asString(Keywords keywords) {
            return this.beforeOrAfterStep.asString(keywords);
        }
    }

    public class UponSuccessStep
    extends AbstractStep {
        private BeforeOrAfterStep beforeOrAfterStep;

        public UponSuccessStep(Method method, Meta storyAndScenarioMeta) {
            this.beforeOrAfterStep = new BeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }

        public String asString(Keywords keywords) {
            return this.beforeOrAfterStep.asString(keywords);
        }
    }

    private class BeforeOrAfterStep
    extends AbstractStep {
        private final Method method;
        private final Meta meta;

        public BeforeOrAfterStep(Method method, Meta meta) {
            this.method = method;
            this.meta = meta;
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            ParameterConverters paramConvertersWithExceptionInjector = this.paramConvertersWithExceptionInjector(storyFailureIfItHappened);
            MethodInvoker methodInvoker = new MethodInvoker(this.method, paramConvertersWithExceptionInjector, StepCreator.this.paranamer, this.meta);
            Timer timer = new Timer().start();
            try {
                methodInvoker.invoke();
                return AbstractStepResult.silent(this.method).withDurationInMillis(timer.stop());
            }
            catch (InvocationTargetException e) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, e.getCause()))).withDurationInMillis(timer.stop());
            }
            catch (Throwable t) {
                return AbstractStepResult.failed(this.method, new UUIDExceptionWrapper(new BeforeOrAfterFailed(this.method, t))).withDurationInMillis(timer.stop());
            }
        }

        private ParameterConverters paramConvertersWithExceptionInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
            return StepCreator.this.parameterConverters.newInstanceAdding(new UUIDExceptionWrapperInjector(storyFailureIfItHappened));
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }

        public String asString(Keywords keywords) {
            return this.method.getName() + ";" + this.meta.asString(keywords);
        }

        private class UUIDExceptionWrapperInjector
        implements ParameterConverters.ParameterConverter {
            private final UUIDExceptionWrapper storyFailureIfItHappened;

            public UUIDExceptionWrapperInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
                this.storyFailureIfItHappened = storyFailureIfItHappened;
            }

            public boolean accept(Type type) {
                return UUIDExceptionWrapper.class == type;
            }

            public Object convertValue(String value, Type type) {
                return this.storyFailureIfItHappened;
            }
        }
    }

    public static abstract class AbstractStep
    implements Step {
        public String asString(Keywords keywords) {
            return this.toString();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class ParameterNotFound
    extends RuntimeException {
        public ParameterNotFound(String name, String[] parameters) {
            super("Parameter not found for name '" + name + "' amongst '" + Arrays.asList(parameters) + "'");
        }

        public ParameterNotFound(int position, String[] parameters) {
            super("Parameter not found for position '" + position + "' amongst '" + Arrays.asList(parameters) + "'");
        }
    }

    public static class Jsr330Helper {
        private static String getNamedValue(Annotation annotation) {
            return ((javax.inject.Named)annotation).value();
        }
    }
}

