/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.mojo.AbstractEmbedderMojo;

public class UnpackViewResources
extends AbstractEmbedderMojo {
    MavenProject project;
    ArchiverManager archiverManager;
    String[] resourceArtifactIds = new String[]{"jbehave-site-resources", "jbehave-core"};
    String[] resourceTypes = new String[]{"zip"};
    String resourceIncludes;
    String resourcesExcludes;
    File viewDirectory;

    public void execute() throws MojoExecutionException {
        File destination = this.viewDirectory();
        for (Artifact artifact : this.resourceArtifacts()) {
            this.unpack(artifact.getFile(), destination, this.resourceIncludes, this.resourcesExcludes);
        }
    }

    private File viewDirectory() {
        if (this.viewDirectory != null) {
            return this.viewDirectory;
        }
        StoryReporterBuilder storyReporterBuilder = this.newEmbedder().configuration().storyReporterBuilder();
        String build = this.project.getBuild().getDirectory();
        String output = storyReporterBuilder.outputDirectory().getName();
        String view = storyReporterBuilder.viewResources().getProperty("viewDirectory");
        return new File(build + "/" + output + "/" + view);
    }

    private Set<Artifact> resourceArtifacts() {
        Set<Artifact> artifacts = this.allArtifacts();
        CollectionUtils.filter(artifacts, (Predicate)new Predicate<Artifact>(){

            public boolean evaluate(Artifact artifact) {
                return UnpackViewResources.this.allowedBy("artifactId", artifact.getArtifactId(), UnpackViewResources.this.resourceArtifactIds) && UnpackViewResources.this.allowedBy("type", artifact.getType(), UnpackViewResources.this.resourceTypes);
            }
        });
        return artifacts;
    }

    private boolean allowedBy(String name, String property, String[] values) {
        boolean allowed = false;
        if (values.length > 0) {
            for (String value : values) {
                if (!property.equals(value)) continue;
                allowed = true;
                break;
            }
        } else {
            allowed = true;
        }
        if (!allowed) {
            this.getLog().debug((CharSequence)("Artifact property " + name + " not allowed by values " + Arrays.asList(values)));
        }
        return allowed;
    }

    private Set<Artifact> allArtifacts() {
        return new HashSet<Artifact>(this.project.getArtifacts());
    }

    private void unpack(File file, File destination, String includes, String excludes) throws MojoExecutionException {
        try {
            destination.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(destination);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
            this.getLog().info((CharSequence)("Unpacked " + file + " to " + destination));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed unpacking " + file + " to " + destination, e);
        }
    }
}

