/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.ExpressionParser;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.dmr.ModelNode;

public class IfElseBlock {
    private static final String IF_BLOCK = "IF";
    private static final byte IN_IF = 0;
    private static final byte IN_ELSE = 1;
    private byte state;
    private Operation conditionExpression;
    private ModelNode conditionRequest;
    private ModelNode ifRequest;

    public static IfElseBlock create(CommandContext ctx) throws CommandLineException {
        if (ctx.get(IF_BLOCK) != null) {
            throw new CommandLineException("Nesting if blocks are not supported.");
        }
        IfElseBlock ifBlock = new IfElseBlock();
        ctx.set(IF_BLOCK, ifBlock);
        return ifBlock;
    }

    public static IfElseBlock get(CommandContext ctx) throws CommandLineException {
        IfElseBlock ifBlock = (IfElseBlock)ctx.get(IF_BLOCK);
        if (ifBlock == null) {
            throw new CommandLineException("Not in an if block.");
        }
        return ifBlock;
    }

    public static IfElseBlock remove(CommandContext ctx) throws CommandLineException {
        IfElseBlock ifBlock = (IfElseBlock)ctx.remove(IF_BLOCK);
        if (ifBlock == null) {
            throw new CommandLineException("Not in an if block.");
        }
        return ifBlock;
    }

    public void setCondition(String condition, ModelNode request) throws CommandLineException {
        if (condition == null) {
            throw new CommandFormatException("The path of the if condition can't be null.");
        }
        if (request == null) {
            throw new CommandFormatException("The request in the if condition can't be null.");
        }
        this.conditionExpression = new ExpressionParser().parseExpression(condition);
        this.conditionRequest = request;
        this.state = 0;
    }

    public ModelNode getConditionRequest() {
        return this.conditionRequest;
    }

    public Operation getConditionExpression() {
        return this.conditionExpression;
    }

    public void setIfRequest(ModelNode request) throws CommandLineException {
        if (request == null) {
            throw new CommandLineException("if request is null.");
        }
        if (this.ifRequest != null) {
            throw new CommandLineException("if request is already initialized: " + this.ifRequest);
        }
        this.ifRequest = request;
    }

    public ModelNode getIfRequest() {
        return this.ifRequest;
    }

    public boolean isInIf() {
        return this.state == 0;
    }

    public boolean isInElse() {
        return this.state == 1;
    }

    public void setInElse() {
        this.state = 1;
    }
}

