/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beanvalidation.deployers;

import javax.validation.ValidatorFactory;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;

public class ValidatorFactoryDeployer
extends AbstractRealDeployer {
    private BeanFactory factory;
    private DeploymentUnitFilter filter;

    public ValidatorFactoryDeployer(BeanFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory");
        }
        this.setStage(DeploymentStages.PRE_REAL);
        this.setOutput(ValidatorFactory.class);
        this.factory = factory;
    }

    protected boolean isRelevant(DeploymentUnit unit) {
        return this.filter != null && this.filter.accepts(unit);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (this.isRelevant(unit)) {
            try {
                Object result = this.factory.createBean();
                ValidatorFactory vf = (ValidatorFactory)ValidatorFactory.class.cast(result);
                unit.addAttachment(ValidatorFactory.class, (Object)vf);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Error creating validator factory", (Throwable)t);
            }
        }
    }

    public void setFilter(DeploymentUnitFilter filter) {
        this.filter = filter;
    }
}

