/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beanvalidation.util;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ValidatorFactory;
import org.jboss.beanvalidation.util.JndiBinder;
import org.jboss.logging.Logger;
import org.jboss.util.naming.NonSerializableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJndiBinder
implements JndiBinder {
    protected static Logger log = Logger.getLogger(DefaultJndiBinder.class);
    public static final String BV_FACTORY_JNDI_SUBCONTEXT = "BeanValidatorFactories";
    private Hashtable jndiEnvironment;
    private Context bvFactoryContext;

    public DefaultJndiBinder() {
        this(new Hashtable(1));
    }

    public DefaultJndiBinder(Hashtable jndiEnvironment) {
        this.setEnvironment(jndiEnvironment);
        this.createSubContextForFactories();
    }

    protected void createSubContextForFactories() {
        try {
            InitialContext root = new InitialContext(this.jndiEnvironment);
            this.bvFactoryContext = root.createSubcontext(BV_FACTORY_JNDI_SUBCONTEXT);
        }
        catch (NamingException e) {
            log.error((Object)"Unable to create JNDI subcontext for Bean Validation Factories", (Throwable)e);
        }
    }

    protected void setEnvironment(Hashtable environment) {
        this.setNonSerializableFactory(environment);
        this.jndiEnvironment = environment;
    }

    protected void setNonSerializableFactory(Hashtable<String, String> environment) {
        String nonSerializableFactory = NonSerializableFactory.class.getName();
        String objFactory = environment.get("java.naming.factory.object");
        objFactory = objFactory != null ? nonSerializableFactory + ":" + objFactory : nonSerializableFactory;
        environment.put("java.naming.factory.object", objFactory);
    }

    @Override
    public void bind(String name, ValidatorFactory validatorFactory) throws NamingException {
        NonSerializableFactory.rebind((Context)this.bvFactoryContext, (String)name, (Object)validatorFactory);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.bvFactoryContext.unbind(name);
        NonSerializableFactory.unbind((String)name);
    }
}

