/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptor;
import org.jboss.bootstrap.api.descriptor.BootstrapDescriptorBase;

public class UrlBootstrapDescriptor
extends BootstrapDescriptorBase
implements BootstrapDescriptor {
    private static final Logger log = Logger.getLogger(UrlBootstrapDescriptor.class.getName());
    private final URL url;

    public UrlBootstrapDescriptor(URL url) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("url must be specified");
        }
        this.url = url;
    }

    @Override
    public String getName() {
        return this.url.toExternalForm();
    }

    @Override
    public InputStream getContent() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not obtain content stream from " + this.url.toExternalForm(), e);
        }
    }
}

