/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;

class LocalJvmSerializableFutureWrapper<V>
implements Serializable,
Future<V> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Future<?>> DELEGATE_REFERENCE_DURING_SERIALIZATION = new ThreadLocal();
    private static final Logger log = Logger.getLogger(LocalJvmSerializableFutureWrapper.class);
    private transient Future<V> delegate;

    LocalJvmSerializableFutureWrapper(Future<V> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must be specified");
        }
        this.delegate = delegate;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        DELEGATE_REFERENCE_DURING_SERIALIZATION.set(this.delegate);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.delegate = DELEGATE_REFERENCE_DURING_SERIALIZATION.get();
        if (this.delegate == null) {
            throw new IllegalStateException("Delegate was null during deserialization");
        }
        DELEGATE_REFERENCE_DURING_SERIALIZATION.set(null);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }
}

