/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.DomainDefinition;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.async.spi.AttachmentNames;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.ejb3.instantiator.spi.BeanInstantiatorRegistration;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.ejb3.singleton.aop.impl.AOPBasedSingletonContainer;
import org.jboss.ejb3.singleton.deployer.StartupSingletonInitiator;
import org.jboss.ejb3.singleton.impl.resolver.EjbLinkResolver;
import org.jboss.injection.injector.EEInjector;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.injection.mc.metadata.JndiEnvironmentImpl;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.spi.Barrier;

public class SingletonContainerDeployer
extends AbstractRealDeployerWithInput<JBossEnterpriseBeanMetaData>
implements DeploymentVisitor<JBossEnterpriseBeanMetaData> {
    private static Logger logger = Logger.getLogger(SingletonContainerDeployer.class);
    private MessageDestinationReferenceResolver messageDestinationResolver;
    private EjbReferenceResolver ejbReferenceResolver;
    private PersistenceUnitDependencyResolver puResolver;
    private JavaEEComponentInformer javaeeComponentInformer;

    public SingletonContainerDeployer() {
        this.setDeploymentVisitor(this);
        this.setInput(JBossEnterpriseBeanMetaData.class);
        this.setComponentsOnly(true);
        this.addInput(org.jboss.ejb3.common.deployers.spi.AttachmentNames.PROCESSED_METADATA);
        this.addInput(AttachmentNames.ASYNC_INVOCATION_PROCESSOR);
        this.addInput(Barrier.class);
        this.addInput(InjectionManager.class);
        this.addOutput(BeanMetaData.class);
        this.addOutput(EJBContainer.class);
        this.addOutput(org.jboss.ejb3.container.spi.EJBContainer.class);
    }

    public void deploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMetaData) throws DeploymentException {
        AOPBasedSingletonContainer singletonContainer;
        if (!this.isSingletonBean(beanMetaData)) {
            return;
        }
        ExecutorService asyncExecutorService = (ExecutorService)unit.getAttachment(AttachmentNames.ASYNC_INVOCATION_PROCESSOR);
        if (asyncExecutorService == null) {
            throw new IllegalStateException("No async executor available for deployment unit " + unit);
        }
        JBossSessionBean31MetaData singletonBean = (JBossSessionBean31MetaData)beanMetaData;
        ClassLoader classLoader = unit.getClassLoader();
        String domainName = AOPBasedSingletonContainer.getAOPDomainName();
        DomainDefinition singletonContainerAOPDomain = AspectManager.instance().getContainer(domainName);
        if (singletonContainerAOPDomain == null) {
            throw new DeploymentException(domainName + " AOP domain not configured - cannot deploy EJB named " + beanMetaData.getEjbName() + " in unit " + unit);
        }
        Hashtable ctxProperties = new Hashtable();
        try {
            singletonContainer = new AOPBasedSingletonContainer(classLoader, singletonBean.getEjbClass(), singletonBean.getEjbName(), (Domain)singletonContainerAOPDomain.getManager(), ctxProperties, singletonBean, unit, asyncExecutorService);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException((Throwable)cnfe);
        }
        singletonContainer.setJaccContextId(unit.getSimpleName());
        singletonContainer.setEjbReferenceResolver(this.ejbReferenceResolver);
        singletonContainer.setMessageDestinationResolver(this.messageDestinationResolver);
        singletonContainer.setPersistenceUnitResolver(this.puResolver);
        singletonContainer.instantiated();
        singletonContainer.processMetadata();
        this.attachContainerBMD(unit, singletonContainer.getObjectName().getCanonicalName(), singletonContainer);
        if (singletonBean.isInitOnStartup()) {
            StartupSingletonInitiator startupSingletonInitiator = new StartupSingletonInitiator((org.jboss.ejb3.container.spi.EJBContainer)singletonContainer);
            this.attachStartupSingletonInitiatorBMD(startupSingletonInitiator, (org.jboss.ejb3.container.spi.EJBContainer)singletonContainer, unit);
        }
    }

    public void undeploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData enterpriseBean) {
    }

    public Class<JBossEnterpriseBeanMetaData> getVisitorType() {
        return JBossEnterpriseBeanMetaData.class;
    }

    private boolean isSingletonBean(JBossEnterpriseBeanMetaData beanMetaData) {
        if (!beanMetaData.getJBossMetaData().isEJB31()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a EJB3.1 bean " + beanMetaData.getName()));
            }
            return false;
        }
        if (!beanMetaData.isSession()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a session bean " + beanMetaData.getName()));
            }
            return false;
        }
        if (!(beanMetaData instanceof JBossSessionBean31MetaData)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Session bean " + beanMetaData.getName() + " is not of type " + JBossSessionBean31MetaData.class));
            }
            return false;
        }
        JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)beanMetaData;
        if (!sessionBean.isSingleton()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not a singleton bean " + sessionBean.getName()));
            }
            return false;
        }
        return true;
    }

    private void attachContainerBMD(DeploymentUnit unit, String containerMCBeanName, AOPBasedSingletonContainer container) {
        BeanMetaDataBuilder containerBMDBuilder = BeanMetaDataBuilder.createBuilder((String)containerMCBeanName, (String)container.getClass().getName());
        containerBMDBuilder.setConstructorValue((Object)container);
        DependencyPolicy containerDependencyPolicy = container.getDependencyPolicy();
        Barrier switchBoard = (Barrier)unit.getAttachment(Barrier.class);
        if (switchBoard == null) {
            throw new RuntimeException("No SwitchBoard Barrier found for bean: " + container.getEjbName() + " in unit: " + unit);
        }
        containerBMDBuilder.addDemand((Object)switchBoard.getId(), ControllerState.CREATE, ControllerState.START, null);
        logger.debug((Object)("Added dependency on switchboard " + switchBoard.getId() + " for container " + container.getName()));
        InjectionManager injectionManager = (InjectionManager)unit.getAttachment(InjectionManager.class);
        if (injectionManager == null) {
            throw new RuntimeException("No InjectionManager found for bean: " + container.getEjbName() + " in unit: " + unit);
        }
        container.setInjectionManager(injectionManager);
        this.setupInjectors(unit, container, injectionManager, switchBoard);
        JBossSessionBean31MetaData sessionBeanMetaData = (JBossSessionBean31MetaData)container.getMetaData();
        String[] dependsOn = sessionBeanMetaData.getDependsOn();
        if (dependsOn != null) {
            AbstractListMetaData containerDependencies = new AbstractListMetaData();
            EjbLinkResolver ejbLinkResolver = new EjbLinkResolver();
            for (String dependency : dependsOn) {
                JBossEnterpriseBeanMetaData dependencyBean = ejbLinkResolver.resolveEJB(dependency, unit);
                if (dependencyBean == null) {
                    throw new RuntimeException("Could not resolve bean for @DependsOn/depends-on with ejb-name: " + dependency + " while processing EJB named " + container.getEJBName());
                }
                if (!this.isSingletonBean(dependencyBean)) {
                    throw new RuntimeException("@DependsOn/depends-on can only refer to Singleton beans. " + dependencyBean.getEjbClass() + " is not a singleton bean");
                }
                List<String> jndiNames = this.getExposedJNDINames((JBossSessionBean31MetaData)dependencyBean);
                for (String jndiName : jndiNames) {
                    containerDependencyPolicy.addDependency("jndi:" + jndiName);
                }
                String dependencyBeanContainerName = dependencyBean.getContainerName();
                AbstractInjectionValueMetaData containerDependencyInjection = new AbstractInjectionValueMetaData((Object)dependencyBeanContainerName);
                containerDependencies.add((MetaDataVisitorNode)containerDependencyInjection);
            }
            containerBMDBuilder.addPropertyMetaData("singletonDependsOn", (ValueMetaData)containerDependencies);
        }
        logger.info((Object)("Installing container for EJB " + container.getEJBName()));
        if (containerDependencyPolicy instanceof MCDependencyPolicy) {
            MCDependencyPolicy policy = (MCDependencyPolicy)containerDependencyPolicy;
            logger.info((Object)"with dependencies: ");
            Set dependencies = policy.getDependencies();
            if (dependencies != null && !dependencies.isEmpty()) {
                for (DependencyMetaData dependency : dependencies) {
                    logger.info(dependency.getDependency());
                    containerBMDBuilder.addDependency(dependency.getDependency());
                }
            }
            logger.info((Object)"with demands: ");
            Set demands = policy.getDemands();
            if (demands != null && !demands.isEmpty()) {
                for (DemandMetaData demand : demands) {
                    logger.info(demand.getDemand());
                    containerBMDBuilder.addDemand(demand.getDemand());
                }
            }
            logger.info((Object)"with supplies: ");
            Set supplies = policy.getSupplies();
            if (supplies != null && !supplies.isEmpty()) {
                for (SupplyMetaData supply : supplies) {
                    logger.info(supply.getSupply());
                    containerBMDBuilder.addSupply(supply.getSupply());
                }
            }
        }
        String javaCompMCBeanName = this.getJavaEEComponentMCBeanName(unit);
        AbstractInjectionValueMetaData javaCompInjectMetaData = new AbstractInjectionValueMetaData((Object)javaCompMCBeanName);
        containerBMDBuilder.addPropertyMetaData("javaComp", (ValueMetaData)javaCompInjectMetaData);
        String appName = this.javaeeComponentInformer.getApplicationName(unit);
        String moduleName = this.javaeeComponentInformer.getModuleName(unit);
        String javaeeSpecAppName = appName;
        if (javaeeSpecAppName == null) {
            javaeeSpecAppName = moduleName;
        }
        String beanInstantiatorMcName = BeanInstantiatorRegistration.getInstantiatorRegistrationName((String)javaeeSpecAppName, (String)moduleName, (String)container.getEjbName());
        containerBMDBuilder.addPropertyMetaData("beanInstantiator", (ValueMetaData)new AbstractInjectionValueMetaData((Object)beanInstantiatorMcName));
        DeploymentUnit parentUnit = unit.getParent();
        parentUnit.addAttachment(BeanMetaData.class + ":" + containerMCBeanName, (Object)containerBMDBuilder.getBeanMetaData());
        unit.addAttachment(EJBContainer.class + ":" + containerMCBeanName, (Object)container);
        unit.addAttachment(org.jboss.ejb3.container.spi.EJBContainer.class, (Object)container);
    }

    private String getJavaEEComponentMCBeanName(DeploymentUnit deploymentUnit) {
        String applicationName = this.javaeeComponentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.javaeeComponentInformer.getModuleName(deploymentUnit);
        String componentName = this.javaeeComponentInformer.getComponentName(deploymentUnit);
        StringBuilder builder = new StringBuilder("jboss.naming:");
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (componentName != null) {
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    @Inject
    public void setPersistenceUnitResolver(PersistenceUnitDependencyResolver puResolver) {
        this.puResolver = puResolver;
    }

    @Inject
    public void setMessageDestinationResolver(MessageDestinationReferenceResolver messageDestResolver) {
        this.messageDestinationResolver = messageDestResolver;
    }

    @Inject
    public void setEjbRefResolver(EjbReferenceResolver ejbRefResolver) {
        this.ejbReferenceResolver = ejbRefResolver;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }

    private List<String> getExposedJNDINames(JBossSessionBean31MetaData sessionBean) {
        String noInterfaceJNDIName;
        String defaultRemoteJNDIName;
        String defaultLocalJNDIName;
        boolean hasRemoteBusinessView;
        ArrayList<String> jndiNames = new ArrayList<String>();
        DefaultJndiBindingPolicy jndiPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndiPolicy);
        BusinessRemotesMetaData businessRemotes = sessionBean.getBusinessRemotes();
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        boolean hasLocalBusinessView = businessLocals != null && businessLocals.size() > 0;
        boolean bl = hasRemoteBusinessView = businessRemotes != null && businessRemotes.size() > 0;
        if (hasLocalBusinessView && (defaultLocalJNDIName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean)) != null) {
            jndiNames.add(defaultLocalJNDIName);
        }
        if (hasRemoteBusinessView && (defaultRemoteJNDIName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean)) != null) {
            jndiNames.add(defaultRemoteJNDIName);
        }
        if (sessionBean.isNoInterfaceBean() && (noInterfaceJNDIName = jndiNameResolver.resolveNoInterfaceJNDIName(sessionBean)) != null) {
            jndiNames.add(noInterfaceJNDIName);
        }
        return jndiNames;
    }

    private void setupInjectors(DeploymentUnit unit, AOPBasedSingletonContainer container, InjectionManager injectionManager, Barrier switchBoard) {
        InterceptorsMetaData interceptors;
        JBossEnterpriseBeanMetaData beanMetaData = container.getXml();
        JndiEnvironmentImpl jndiEnvironment = new JndiEnvironmentImpl((Environment)beanMetaData, container.getClassloader());
        if (this.hasInjectionTargets((JndiEnvironmentRefsGroup)jndiEnvironment)) {
            EEInjector eeInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironment);
            injectionManager.addInjector((Injector)eeInjector);
            String injectorMCBeanName = this.getInjectorMCBeanNamePrefix(unit) + ",bean=" + container.getEjbName();
            BeanMetaData injectorBMD = this.createInjectorBMD(injectorMCBeanName, eeInjector, switchBoard);
            unit.getParent().addAttachment(BeanMetaData.class + ":" + injectorMCBeanName, (Object)injectorBMD);
            DependencyPolicy dependsPolicy = container.getDependencyPolicy();
            dependsPolicy.addDependency(injectorMCBeanName);
            this.log.debug((Object)("Added Injector dependency: " + injectorMCBeanName + " for EJB: " + container.getEjbName() + " in unit " + unit));
        }
        if ((interceptors = JBossMetaData.getInterceptors((String)beanMetaData.getEjbName(), (JBossMetaData)beanMetaData.getJBossMetaData())) == null || interceptors.isEmpty()) {
            return;
        }
        for (InterceptorMetaData interceptor : interceptors) {
            JndiEnvironmentImpl jndiEnvironmentForInterceptor;
            if (interceptor == null || !this.hasInjectionTargets((JndiEnvironmentRefsGroup)(jndiEnvironmentForInterceptor = new JndiEnvironmentImpl((Environment)interceptor, container.getClassloader())))) continue;
            EEInjector eeInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironmentForInterceptor);
            injectionManager.addInjector((Injector)eeInjector);
            String interceptorInjectorMCBeanName = this.getInjectorMCBeanNamePrefix(unit) + ",bean=" + container.getEjbName() + ",interceptor=" + interceptor.getName();
            BeanMetaData injectorBMD = this.createInjectorBMD(interceptorInjectorMCBeanName, eeInjector, switchBoard);
            unit.getParent().addAttachment(BeanMetaData.class + ":" + interceptorInjectorMCBeanName, (Object)injectorBMD);
            DependencyPolicy dependsPolicy = container.getDependencyPolicy();
            dependsPolicy.addDependency(interceptorInjectorMCBeanName);
            this.log.debug((Object)("Added Injector dependency: " + interceptorInjectorMCBeanName + " for interceptor " + interceptor.getName() + " of EJB: " + container.getEjbName() + " in unit " + unit));
        }
    }

    private boolean hasInjectionTargets(JndiEnvironmentRefsGroup jndiEnv) {
        Collection envEntries = jndiEnv.getEntries();
        if (envEntries == null || envEntries.isEmpty()) {
            return false;
        }
        for (EnvironmentEntryType envEntry : envEntries) {
            Collection injectionTargets = envEntry.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private BeanMetaData createInjectorBMD(String injectorMCBeanName, EEInjector injector, Barrier barrier) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)injectorMCBeanName, (String)injector.getClass().getName());
        builder.setConstructorValue((Object)injector);
        builder.addDemand((Object)barrier.getId(), ControllerState.CREATE, ControllerState.START, null);
        return builder.getBeanMetaData();
    }

    private void attachStartupSingletonInitiatorBMD(StartupSingletonInitiator startupSingletonInitiator, org.jboss.ejb3.container.spi.EJBContainer container, DeploymentUnit unit) {
        String initiatorName = this.getStartupSingletonInitiatorMCBeanName(unit, container);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)initiatorName, (String)startupSingletonInitiator.getClass().getName());
        builder.setConstructorValue((Object)startupSingletonInitiator);
        String containerName = container.getMetaData().getContainerName();
        builder.addDependency((Object)containerName);
        Barrier switchBoard = (Barrier)unit.getAttachment(Barrier.class);
        if (switchBoard == null) {
            throw new RuntimeException("No SwitchBoard Barrier in unit: " + unit);
        }
        builder.addDemand((Object)switchBoard.getId(), ControllerState.CREATE, ControllerState.INSTALLED, null);
        if (unit.isComponent()) {
            unit.getParent().addAttachment(BeanMetaData.class + ":" + initiatorName, (Object)builder.getBeanMetaData());
        } else {
            unit.addAttachment(BeanMetaData.class + ":" + initiatorName, (Object)builder.getBeanMetaData());
        }
    }

    private String getStartupSingletonInitiatorMCBeanName(DeploymentUnit unit, org.jboss.ejb3.container.spi.EJBContainer container) {
        StringBuilder sb = new StringBuilder("startup-singleton-initiator:");
        DeploymentUnit topLevelUnit = unit.isTopLevel() ? unit : unit.getTopLevel();
        sb.append("topLevelUnit=");
        sb.append(topLevelUnit.getSimpleName());
        sb.append(",unit=");
        sb.append(unit.getSimpleName());
        sb.append(",bean=");
        sb.append(container.getEJBName());
        return sb.toString();
    }

    private String getInjectorMCBeanNamePrefix(DeploymentUnit unit) {
        StringBuilder sb = new StringBuilder("jboss-injector:");
        DeploymentUnit topLevelUnit = unit.isTopLevel() ? unit : unit.getTopLevel();
        sb.append("topLevelUnit=");
        sb.append(topLevelUnit.getSimpleName());
        sb.append(",");
        sb.append("unit=");
        sb.append(unit.getSimpleName());
        return sb.toString();
    }
}

