/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.plugins.dependency.AttributeInfo;
import org.jboss.kernel.plugins.dependency.BasicCollectionCallbackItemFactory;
import org.jboss.kernel.plugins.dependency.ClassAttributeCallbackItem;
import org.jboss.kernel.plugins.dependency.ClassSingleCallbackItem;
import org.jboss.kernel.plugins.dependency.CollectionCallbackItemFactory;
import org.jboss.kernel.plugins.dependency.MethodAttributeInfo;
import org.jboss.kernel.plugins.dependency.PropertyAttributeInfo;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackCreatorUtil {
    protected static volatile Logger log;
    protected static volatile CollectionCallbackItemFactory factory;

    protected static Logger getLog() {
        if (log == null) {
            log = Logger.getLogger(CallbackCreatorUtil.class);
        }
        return log;
    }

    private static CallbackItem<Class<?>> createCollectionCallback(TypeInfo info, KernelControllerContext context, AttributeInfo attribute, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        if (info instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)info;
            TypeInfo componentType = ci.getComponentType();
            if (componentType == null) {
                throw new IllegalArgumentException("Null component type: " + info);
            }
            Class clazz = componentType.getType();
            if (Object.class.equals((Object)clazz)) {
                throw new IllegalArgumentException("Component type too general - equals Object: " + info);
            }
            Class collectionType = info.getType();
            CollectionCallbackItemFactory factory = CallbackCreatorUtil.getCollectionFactory();
            return factory.createCollectionCallbackItem(collectionType, clazz, whenRequired, dependentState, cardinality, (InvokeDispatchContext)context, attribute);
        }
        throw new IllegalArgumentException("Unable to determine collection element class type: " + info);
    }

    public static CallbackItem<Class<?>> createCallback(KernelControllerContext context, AttributeInfo ai, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        if (!ai.isValid()) {
            throw new IllegalArgumentException("Not a valid attribute info: " + ai);
        }
        TypeInfo info = ai.getType();
        if (info.isCollection()) {
            return CallbackCreatorUtil.createCollectionCallback(info, context, ai, whenRequired, dependentState, cardinality);
        }
        if (ai.isProperty()) {
            return new ClassAttributeCallbackItem(info.getType(), whenRequired, dependentState, cardinality, (AttributeDispatchContext)context, ai.getName());
        }
        return new ClassSingleCallbackItem(info.getType(), whenRequired, dependentState, cardinality, (InvokeDispatchContext)context, ai.getName(), info.getName());
    }

    public static CallbackItem<Class<?>> createCallback(KernelControllerContext context, PropertyInfo pi, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        return CallbackCreatorUtil.createCallback(context, new PropertyAttributeInfo(pi), whenRequired, dependentState, cardinality);
    }

    public static CallbackItem<Class<?>> createCallback(KernelControllerContext context, MethodInfo mi, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality) {
        return CallbackCreatorUtil.createCallback(context, new MethodAttributeInfo(mi), whenRequired, dependentState, cardinality);
    }

    public static CollectionCallbackItemFactory getCollectionFactory() {
        if (factory == null) {
            FactoryLookup lookup = new FactoryLookup();
            factory = AccessController.doPrivileged(lookup);
        }
        return factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryLookup
    implements PrivilegedAction<CollectionCallbackItemFactory> {
        private FactoryLookup() {
        }

        @Override
        public CollectionCallbackItemFactory run() {
            try {
                String factoryClassName = System.getProperty("org.jboss.dependency.collectionCallbackItemFactory", BasicCollectionCallbackItemFactory.class.getName());
                Object result = ReflectionUtils.newInstance((String)factoryClassName);
                return (CollectionCallbackItemFactory)CollectionCallbackItemFactory.class.cast(result);
            }
            catch (Throwable t) {
                CallbackCreatorUtil.getLog().warn((Object)"Exception while creating CollectionCallbackItemFactory, using basic one instead.", t);
                return new BasicCollectionCallbackItemFactory();
            }
        }
    }
}

