/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.event;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventEmitter;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.logging.Logger;

public class AbstractEventEmitter
implements KernelEventEmitter {
    private static final Logger log = Logger.getLogger(AbstractEventEmitter.class);
    protected static final Object NULL = new Object();
    protected static final KernelEventFilter NULL_FILTER = new KernelEventFilter(){

        public boolean wantEvent(KernelEvent event, Object handback) {
            return false;
        }
    };
    protected Map<KernelEventFilter, Map<Object, List<KernelEventListener>>> eventListenerRegistry = new ConcurrentHashMap<KernelEventFilter, Map<Object, List<KernelEventListener>>>();
    private long emitterSequence = 0L;

    public boolean hasListeners() {
        return !this.eventListenerRegistry.isEmpty();
    }

    public KernelEvent createEvent(String type, Object context) {
        return new AbstractEvent(this, type, this.nextEmitterSequence(), System.currentTimeMillis(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        KernelEventFilter filterObject = filter == null ? NULL_FILTER : filter;
        Object handbackObject = handback == null ? NULL : handback;
        Map<KernelEventFilter, Map<Object, List<KernelEventListener>>> map = this.eventListenerRegistry;
        synchronized (map) {
            List<KernelEventListener> listeners;
            Map<Object, List<KernelEventListener>> handbacks = this.eventListenerRegistry.get(filterObject);
            if (handbacks == null) {
                handbacks = new ConcurrentHashMap<Object, List<KernelEventListener>>();
                this.eventListenerRegistry.put(filterObject, handbacks);
            }
            if ((listeners = handbacks.get(handbackObject)) == null) {
                listeners = new CopyOnWriteArrayList<KernelEventListener>();
                handbacks.put(handbackObject, listeners);
            }
            listeners.add(listener);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        KernelEventFilter filterObject = filter == null ? NULL_FILTER : filter;
        Object handbackObject = handback == null ? NULL : handback;
        Map<KernelEventFilter, Map<Object, List<KernelEventListener>>> map = this.eventListenerRegistry;
        synchronized (map) {
            List<KernelEventListener> listeners;
            Map<Object, List<KernelEventListener>> handbacks = this.eventListenerRegistry.get(filterObject);
            if (handbacks != null && (listeners = handbacks.get(handbackObject)) != null && listeners.remove(listener)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unregistered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this));
                }
                return;
            }
        }
        throw new IllegalStateException("Listener not registered.");
    }

    public void fireKernelEvent(KernelEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Firing event: " + event + " on object " + this));
        }
        if (!this.eventListenerRegistry.isEmpty()) {
            for (Map.Entry<KernelEventFilter, Map<Object, List<KernelEventListener>>> registryEntry : this.eventListenerRegistry.entrySet()) {
                Map<Object, List<KernelEventListener>> handbacks = registryEntry.getValue();
                if (handbacks == null) continue;
                KernelEventFilter filter = null;
                KernelEventFilter filterObject = registryEntry.getKey();
                if (filterObject != NULL_FILTER) {
                    filter = filterObject;
                }
                for (Map.Entry<Object, List<KernelEventListener>> handbackEntry : handbacks.entrySet()) {
                    List<KernelEventListener> listeners = handbackEntry.getValue();
                    if (listeners == null) continue;
                    Object handback = handbackEntry.getKey();
                    if (handback == NULL) {
                        handback = null;
                    }
                    ListIterator<KernelEventListener> k = listeners.listIterator();
                    while (k.hasNext()) {
                        KernelEventListener listener = k.next();
                        try {
                            if (filter != null && !filter.wantEvent(event, handback)) continue;
                            this.fireKernelEvent(listener, event, handback);
                        }
                        catch (Throwable t) {
                            log.debugf(t, "Ignored unhandled throwable: ", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    protected void fireKernelEvent(KernelEventListener listener, KernelEvent event, Object handback) {
        listener.onEvent(event, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long nextEmitterSequence() {
        Map<KernelEventFilter, Map<Object, List<KernelEventListener>>> map = this.eventListenerRegistry;
        synchronized (map) {
            return this.emitterSequence++;
        }
    }
}

