/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dispatch;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;

class SecurityActions {
    SecurityActions() {
    }

    public static ClassLoader getClassLoader(final InvokeDispatchContext context) throws Throwable {
        if (System.getSecurityManager() == null) {
            return context.getClassLoader();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    try {
                        return context.getClassLoader();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error retrieving classloader", e);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }
}

