/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.MediaTypeHelper;

public class NettyUtil {
    public static ResteasyUriInfo extractUriInfo(HttpRequest request, String contextPath, String protocol) {
        String host = HttpHeaders.getHost((HttpMessage)request, (String)"unknown");
        String uri = request.getUri();
        String uriString = protocol + "://" + host + uri;
        URI absoluteURI = URI.create(uriString);
        URI noQuery = UriBuilder.fromUri((String)uriString).replaceQuery(null).build(new Object[0]);
        return new ResteasyUriInfo(uriString, absoluteURI.getRawQuery(), contextPath);
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpRequest request) {
        MultivaluedMap<String, String> requestHeaders = NettyUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        Map<String, Cookie> cookies = NettyUtil.extractCookies(requestHeaders);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, Cookie> extractCookies(MultivaluedMap<String, String> headers) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeaders = (List)headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return cookies;
        }
        for (String cookieHeader : cookieHeaders) {
            for (Cookie cookie : CookieParser.parseCookies((String)cookieHeader)) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader((String)accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpRequest request) {
        Headers requestHeaders = new Headers();
        for (Map.Entry header : request.headers()) {
            requestHeaders.add(header.getKey(), header.getValue());
        }
        return requestHeaders;
    }
}

