/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.visitor;

import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.classpool.ClassPoolFactory;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

public class JavassistReflectProvider
implements ReflectProvider {
    private Map<ClassLoader, ClassPool> poolMap = new WeakHashMap<ClassLoader, ClassPool>();

    private ClassPool getClassPool(ClassLoader cl) {
        ClassPool pool = this.poolMap.get(cl);
        if (pool == null) {
            ClassPoolFactory factory = JavassistTypeInfoFactoryImpl.getPoolFactory();
            pool = factory.getPoolForLoader(cl);
            ClassPool defaultCP = ClassPool.getDefault();
            if (pool == null || pool == defaultCP) {
                pool = new ClassPool();
                LoaderClassPath path = new LoaderClassPath(cl);
                pool.appendClassPath((ClassPath)path);
            }
            this.poolMap.put(cl, pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeInfo getTypeInfo(ResourceContext resource) throws Throwable {
        InputStream stream = resource.getInputStream();
        if (stream == null) {
            throw new IllegalArgumentException("Null stream: " + resource);
        }
        try {
            CtClass ctClass = this.getClassPool(resource.getClassLoader()).makeClassIfNew(stream);
            TypeInfo typeInfo = JavassistUtil.toTypeInfo((CtClass)ctClass);
            return typeInfo;
        }
        finally {
            stream.close();
        }
    }
}

