/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.auth.spi.UsersObjectModelFactory;
import org.jboss.security.authorization.config.SecurityConfigObjectModelFactory;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.PolicyConfig;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBParsingUtil {
    private XMLLoginConfigImpl xmlConfig = XMLLoginConfigImpl.getInstance();

    public void parse(URL loginConfigURL, ArrayList<String> configNames) throws Exception {
        SecurityConfigObjectModelFactory lcomf = new SecurityConfigObjectModelFactory();
        UsersObjectModelFactory uomf = new UsersObjectModelFactory();
        InputStreamReader xmlReader = this.loadURL(loginConfigURL);
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        unmarshaller.mapFactoryToNamespace((ObjectModelFactory)uomf, "http://www.jboss.org/j2ee/schemas/XMLLoginModule");
        Object root = null;
        PolicyConfig config = (PolicyConfig)unmarshaller.unmarshal((Reader)xmlReader, (ObjectModelFactory)lcomf, root);
        Set<String> cnames = config.getConfigNames();
        configNames.addAll(cnames);
        this.xmlConfig.copy(config);
        for (String cname : cnames) {
            ApplicationPolicy ap = config.get(cname);
            SecurityConfiguration.addApplicationPolicy(ap);
            this.handleJASPIDelegation(ap);
        }
    }

    private void handleJASPIDelegation(ApplicationPolicy aPolicy) {
        BaseAuthenticationInfo bai = aPolicy.getAuthenticationInfo();
        if (bai instanceof JASPIAuthenticationInfo) {
            LoginModuleStackHolder[] lmsharr;
            JASPIAuthenticationInfo jai = (JASPIAuthenticationInfo)bai;
            for (LoginModuleStackHolder lmsh : lmsharr = jai.getLoginModuleStackHolder()) {
                this.xmlConfig.addAppConfig(lmsh.getName(), lmsh.getAppConfigurationEntry());
            }
        }
    }

    private InputStreamReader loadURL(URL configURL) throws IOException {
        InputStream is = configURL.openStream();
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        InputStreamReader xmlReader = new InputStreamReader(is);
        return xmlReader;
    }
}

