/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static URL findResource(final URLClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return cl.findResource(name);
            }
        });
    }

    static InputStream openStream(final URL url) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return url.openStream();
            }
        });
    }
}

