/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.logging.Logger;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AppConfigurationEntryHolder;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.ModuleOption;
import org.jboss.security.config.PolicyConfig;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class LoginConfigObjectModelFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger(LoginConfigObjectModelFactory.class);
    private boolean trace;
    protected final Map<String, ControlFlag> controlFlags = new HashMap<String, ControlFlag>();

    public LoginConfigObjectModelFactory() {
        this.controlFlags.put("REQUIRED", ControlFlag.REQUIRED);
        this.controlFlags.put("REQUISITE", ControlFlag.REQUISITE);
        this.controlFlags.put("OPTIONAL", ControlFlag.OPTIONAL);
        this.controlFlags.put("SUFFICIENT", ControlFlag.SUFFICIENT);
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        if (this.trace) {
            log.trace((Object)"completeRoot");
        }
        return root;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.trace = log.isTraceEnabled();
        if (!localName.equals("policy")) {
            throw new IllegalStateException("Unexpected root element: was expecting 'policy' but got '" + localName + "'");
        }
        if (this.trace) {
            log.trace((Object)"newRoot, created PolicyConfig for policy element");
        }
        return new PolicyConfig();
    }

    public Object newChild(PolicyConfig config, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ApplicationPolicy child = null;
        if (this.trace) {
            log.trace((Object)("newChild.PolicyConfig, localName: " + localName));
        }
        if ("application-policy".equals(localName)) {
            String name = attrs.getValue("name");
            name = StringPropertyReplacer.replaceProperties((String)name);
            ApplicationPolicy aPolicy = new ApplicationPolicy(name);
            aPolicy.setPolicyConfig(config);
            String baseAppPolicyName = attrs.getValue("extends");
            if (baseAppPolicyName != null) {
                aPolicy.setBaseApplicationPolicyName(baseAppPolicyName);
            }
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + name));
            }
            child = aPolicy;
        }
        return child;
    }

    public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        BaseAuthenticationInfo child = null;
        if (this.trace) {
            log.trace((Object)("newChild.ApplicationPolicy, localName: " + localName));
        }
        String name = aPolicy.getName();
        if ("authentication".equals(localName)) {
            child = new AuthenticationInfo(name);
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + name));
            }
        } else if ("authentication-jaspi".equals(localName)) {
            child = new JASPIAuthenticationInfo(name);
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + name));
            }
        }
        return child;
    }

    public Object newChild(BaseAuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        BaseAuthenticationInfo child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthenticationInfo, localName: " + localName));
        }
        if ("authentication".equals(localName)) {
            child = new AuthenticationInfo(info.getName());
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + info.getName()));
            }
        } else if ("authentication-jaspi".equals(localName)) {
            child = new JASPIAuthenticationInfo(info.getName());
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + info.getName()));
            }
        }
        return child;
    }

    public Object newChild(AuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AppConfigurationEntryHolder child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthenticationInfo, localName: " + localName));
        }
        if ("login-module".equals(localName)) {
            AppConfigurationEntryHolder holder;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag != null) {
                flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            }
            child = holder = new AppConfigurationEntryHolder(code, flag);
            if (this.trace) {
                log.trace((Object)("newChild.AuthenticationInfo, login-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(JASPIAuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        Object child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthenticationJaspiInfo, localName: " + localName));
        }
        if ("login-module-stack".equals(localName)) {
            String lmsName = attrs.getValue("name");
            lmsName = StringPropertyReplacer.replaceProperties((String)lmsName.trim());
            child = new LoginModuleStackHolder(lmsName, null);
            if (this.trace) {
                log.trace((Object)("newChild.AuthenticationInfo, login-module-stack: " + lmsName));
            }
        } else if ("auth-module".equals(localName)) {
            String code = attrs.getValue("code");
            AuthModuleEntry authModuleEntry = new AuthModuleEntry(code, null, null);
            String flag = attrs.getValue("flag");
            authModuleEntry.setControlFlag(this.getControlFlag(flag));
            String lmsRef = attrs.getValue("login-module-stack-ref");
            if (lmsRef != null) {
                authModuleEntry.setLoginModuleStackHolder(info.getLoginModuleStackHolder(lmsRef));
            }
            child = authModuleEntry;
        }
        return child;
    }

    public Object newChild(LoginModuleStackHolder entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AppConfigurationEntryHolder child = null;
        if (this.trace) {
            log.trace((Object)("newChild.LoginModuleStackHolder, localName: " + localName));
        }
        if ("login-module".equals(localName)) {
            AppConfigurationEntryHolder holder;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            child = holder = new AppConfigurationEntryHolder(code, flag);
            if (this.trace) {
                log.trace((Object)("newChild.AuthenticationInfo, login-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AppConfigurationEntryHolder entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AppConfigurationEntryHolder, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AppConfigurationEntryHolder, module-option name: " + name));
            }
        }
        return child;
    }

    public Object newChild(AuthModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AppConfigurationEntryHolder, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AuthModuleEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void setValue(ModuleOption option, UnmarshallingContext navigator, String namespaceUri, String localName, String value) {
        if ("module-option".equals(localName)) {
            String valueWithReplacement = StringPropertyReplacer.replaceProperties((String)value.trim());
            option.setValue((Object)valueWithReplacement);
            if (this.trace) {
                log.trace((Object)("setValue.ModuleOption, name: " + localName + ":valueWithReplacement:" + valueWithReplacement));
            }
        }
    }

    public void addChild(ModuleOption option, Object value, UnmarshallingContext navigator, String namespaceURI, String localName) {
        option.setValue(value);
        if (this.trace) {
            log.trace((Object)("addChild.ModuleOption, name: " + option.getName()));
        }
    }

    public void addChild(AuthenticationInfo authInfo, AppConfigurationEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        AppConfigurationEntry entry = entryInfo.getEntry();
        authInfo.addAppConfigurationEntry(entry);
        if (this.trace) {
            log.trace((Object)("addChild.AuthenticationInfo, name: " + entry.getLoginModuleName()));
        }
    }

    public void addChild(AppConfigurationEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
        if (this.trace) {
            log.trace((Object)("addChild.AppConfigurationEntryHolder, name: " + option.getName()));
        }
    }

    public void addChild(JASPIAuthenticationInfo authInfo, AuthModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public void addChild(LoginModuleStackHolder lmsh, AppConfigurationEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        lmsh.addAppConfigurationEntry(entryInfo.getEntry());
        if (this.trace) {
            log.trace((Object)("addChild.LoginModuleStackHolder, name: " + entryInfo.getEntry().getLoginModuleName()));
        }
    }

    public void addChild(AuthModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.addOption(option);
        if (this.trace) {
            log.trace((Object)("addChild.AppConfigurationEntryHolder, name: " + option.getName()));
        }
    }

    public void addChild(JASPIAuthenticationInfo authInfo, LoginModuleStackHolder lmsHolder, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(lmsHolder);
    }

    public void addChild(ApplicationPolicy aPolicy, JASPIAuthenticationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuthenticationInfo(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(ApplicationPolicy aPolicy, AuthenticationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuthenticationInfo(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(PolicyConfig pc, ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceURI, String localName) {
        pc.add(aPolicy);
        if (this.trace) {
            log.trace((Object)("Added ApplicationPolicy to PolicyConfig, name: " + aPolicy.getName()));
        }
    }

    public ControlFlag getControlFlag(String flag) {
        ControlFlag controlFlag = null;
        if (flag != null) {
            flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            controlFlag = this.controlFlags.get(flag.toUpperCase());
        }
        if (controlFlag == null) {
            controlFlag = ControlFlag.REQUIRED;
        }
        return controlFlag;
    }
}

