/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.microcontainer.beans;

import java.util.HashMap;
import java.util.Map;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.microcontainer.beans.BasePolicyBean;
import org.jboss.security.microcontainer.beans.MappingPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingPolicyBean
extends BasePolicyBean<MappingPolicyModule, MappingInfo> {
    public Map<String, MappingInfo> getMappingInfoByType(String domainName) {
        MappingInfo completeInfo = this.getPolicyInfo(domainName);
        HashMap<String, MappingInfo> result = new HashMap<String, MappingInfo>();
        for (MappingModuleEntry entry : completeInfo.getModuleEntries()) {
            String type = entry.getMappingModuleType();
            if (result.containsKey(type)) {
                ((MappingInfo)result.get(type)).add(entry);
                continue;
            }
            MappingInfo info = new MappingInfo(domainName);
            info.add(entry);
            result.put(type, info);
        }
        return result;
    }

    @Override
    public MappingInfo getPolicyInfo(String domainName) {
        MappingInfo info = new MappingInfo(domainName);
        for (MappingPolicyModule module : this.modules) {
            MappingModuleEntry entry = new MappingModuleEntry(module.getCode(), module.getOptions(), module.getType());
            info.add(entry);
        }
        return info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Role-Mapping Policy:\n");
        for (int i = 0; i < this.modules.size(); ++i) {
            MappingPolicyModule module = (MappingPolicyModule)this.modules.get(i);
            buffer.append("Module[" + i + "]\n");
            buffer.append(module.toString());
        }
        return buffer.toString();
    }
}

