/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.domain.Action;
import org.jclouds.sqs.internal.BaseSQSApiExpectTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PermissionApiExpectTest")
public class PermissionApiExpectTest
extends BaseSQSApiExpectTest {
    public HttpRequest addPermission = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"AddPermission"}).addFormParam("ActionName.1", new String[]{"ReceiveMessage"}).addFormParam("AWSAccountId.1", new String[]{"125074342641"}).addFormParam("Label", new String[]{"testLabel"}).addFormParam("Signature", new String[]{"J9sV4q1rJ7dWYJDQp9JxsfEKNXQhpQBYIwBYi1IeXV0%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest removePermission = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"RemovePermission"}).addFormParam("Label", new String[]{"testLabel"}).addFormParam("Signature", new String[]{"VOA0L1uRVKQDQL1Klt0cYUajGoxN4Ur%2B7ISQ2I4RpRs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testAddPermissionWhenResponseIs2xx() throws Exception {
        HttpResponse addPermissionResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(PermissionApiExpectTest.payloadFromStringWithContentType((String)"<AddPermissionsResponse><ResponseMetadata><RequestId>b5293cb5-d306-4a17-9048-b263635abe42</RequestId></ResponseMetadata></AddPermissionsResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.addPermission, addPermissionResponse);
        apiWhenExist.getPermissionApiForQueue(this.queue).addPermissionToAccount("testLabel", Action.RECEIVE_MESSAGE, "125074342641");
    }

    public void testRemovePermissionWhenResponseIs2xx() throws Exception {
        HttpResponse removePermissionResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(PermissionApiExpectTest.payloadFromStringWithContentType((String)"<RemovePermissionsResponse><ResponseMetadata><RequestId>b5293cb5-d306-4a17-9048-b263635abe42</RequestId></ResponseMetadata></RemovePermissionsResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.removePermission, removePermissionResponse);
        apiWhenExist.getPermissionApiForQueue(this.queue).remove("testLabel");
    }
}

