/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.parse;

import com.google.common.hash.HashCodes;
import java.io.InputStream;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.BatchResult;
import org.jclouds.sqs.domain.MessageIdAndMD5;
import org.jclouds.sqs.xml.SendMessageBatchResponseHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SendMessageBatchResponseTest")
public class SendMessageBatchResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/send_message_batch.xml");
        BatchResult<MessageIdAndMD5> expected = this.expected();
        SendMessageBatchResponseHandler handler = (SendMessageBatchResponseHandler)this.injector.getInstance(SendMessageBatchResponseHandler.class);
        BatchResult result = (BatchResult)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public BatchResult<MessageIdAndMD5> expected() {
        return BatchResult.builder().put("test_msg_001", (Object)MessageIdAndMD5.builder().id("0a5231c7-8bff-4955-be2e-8dc7c50a25fa").md5(HashCodes.fromBytes((byte[])CryptoStreams.hex((String)"0e024d309850c78cba5eabbeff7cae71"))).build()).put("test_msg_002", (Object)MessageIdAndMD5.builder().id("15ee1ed3-87e7-40c1-bdaa-2e49968ea7e9").md5(HashCodes.fromBytes((byte[])CryptoStreams.hex((String)"7fb8146a82f95e0af155278f406862c2"))).build()).build();
    }
}

